/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.technology.TechnologyException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfRuntimeManagersBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<ExecutionEnvironmentManagerTO> runtimeManagers;
    private String searchCriteria;
    private List<String> searchedProperties;
    private String runtimeAddress;
    private String newLoadedRuntimeManagerId;

    public void loadAll() throws LocalizedError {
        try {
            this.runtimeManagers = DragonServiceFactory.getInstance().getTechnologyManager().getAllExecutionEnvironmentManagers(this.createSortOption("name", true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            try {
                this.runtimeManagers = DragonServiceFactory.getInstance().getTechnologyManager().searchExecutionEnvironmentManagers(searchCriteria, searchedProperties, this.createSortOption("name", true));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.runtimeManagers == null || this.runtimeManagers.size() == 0) {
                LocalizedError error = new LocalizedError("search_runtime_manager_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    public String loadNew() throws LocalizedError {
        try {
            this.newLoadedRuntimeManagerId = DragonServiceFactory.getInstance().getTechnologyManager().addRuntimeManager(this.runtimeAddress);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        catch (TechnologyException e) {
            LocalizedError error = new LocalizedError("add_runtime_manager_exception");
            error.setType((short)0);
            throw error;
        }
        return "success";
    }

    private RequestOptionsTO createSortOption(String sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String getRuntimeAddress() {
        return this.runtimeAddress;
    }

    public void setRuntimeAddress(String runtimeAddress) {
        this.runtimeAddress = runtimeAddress;
    }

    public String getNewLoadedRuntimeManagerId() {
        return this.newLoadedRuntimeManagerId;
    }

    public void setNewLoadedRuntimeManagerId(String newLoadedRuntimeManagerId) {
        this.newLoadedRuntimeManagerId = newLoadedRuntimeManagerId;
    }

    public List<ExecutionEnvironmentManagerTO> getRuntimeManagers() {
        return this.runtimeManagers;
    }

    public void setRuntimeManagers(List<ExecutionEnvironmentManagerTO> runtimeManagers) {
        this.runtimeManagers = runtimeManagers;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }
}

