/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.dragon.util.XMLPrettyPrinter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class StringHelper {
    private StringHelper() {
    }

    public static boolean equal(String a, String b) {
        boolean result = a == null ? b == null : a.equals(b);
        return result;
    }

    public static boolean equalIgnoreCase(String a, String b) {
        boolean result = a == null ? b == null : a.equalsIgnoreCase(b);
        return result;
    }

    public static String extractValueForAttribute(String string, String attribute, String separator) {
        int start;
        String result = null;
        if (!StringHelper.isNullOrEmpty((String)string) && !StringHelper.isNullOrEmpty((String)attribute) && (start = string.indexOf(attribute)) >= 0 && start < string.length() && (start += attribute.length() + 1) < string.length()) {
            int end = 0;
            if (StringHelper.isNullOrEmpty((String)separator)) {
                end = string.length();
            } else {
                end = string.indexOf(separator, start);
                if (end < 0) {
                    end = string.length();
                }
            }
            result = string.substring(start, end);
        }
        return result;
    }

    public static String HTMLEntityEncode(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buf.append(c);
                continue;
            }
            if (c == '\r' && s.charAt(i + 1) == '\n') {
                buf.append("<br />");
                continue;
            }
            if (c == ' ') {
                buf.append("&nbsp;");
                continue;
            }
            buf.append("&#" + c + ";");
        }
        return buf.toString();
    }

    public static boolean isNotNullAndNotEmpty(String s) {
        return !StringHelper.isNullOrEmpty((String)s);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().equals("");
    }

    public static String prettyPrint(Document xmlDocument) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLPrettyPrinter.prettify((Node)xmlDocument, (OutputStream)outStream);
            result = outStream.toString("UTF-8");
        }
        catch (Exception e) {
            System.err.println("write_dom failed:" + e);
        }
        return result;
    }

    public static String prettyPrint(String xmlString) {
        String result = xmlString;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.newDocumentBuilder();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlString));
            Document document = parser.parse(is);
            result = StringHelper.prettyPrint((Document)document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List<String> splitPathElements(String path) {
        ArrayList<String> pathElements = new ArrayList<String>();
        if (!StringHelper.isNullOrEmpty((String)path)) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                pathElements.add(tokenizer.nextToken());
            }
        }
        return pathElements;
    }

    public static List<String> urlParameterToArray(String parameter) {
        ArrayList<String> urlElements = new ArrayList<String>();
        if (!StringHelper.isNullOrEmpty((String)parameter)) {
            StringTokenizer tokenizer = new StringTokenizer(parameter.substring(1, parameter.length() - 1), ",");
            while (tokenizer.hasMoreTokens()) {
                urlElements.add(tokenizer.nextToken().trim());
            }
        }
        return urlElements;
    }
}

