/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.administration;

import org.apache.log4j.Logger;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.springframework.util.StringUtils;

public class DatabaseAdminBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private String datasetLocation;

    public String loadDataset() throws LocalizedError {
        try {
            if (StringUtils.hasText((String)this.datasetLocation)) {
                DragonServiceFactory.getInstance().getDataLoader().loadDataSet(this.datasetLocation);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String loadDataset(IFileUploadPart file) throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getDataLoader().loadDataset(file.getFileInputStream());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String submit() {
        return "success";
    }

    public String rebuildIndex() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getDataLoader().rebuildIndex();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String getDatasetLocation() {
        return this.datasetLocation;
    }

    public void setDatasetLocation(String datasetLocation) {
        this.datasetLocation = datasetLocation;
    }
}

