/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.RatingTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.api.to.organization.PersonToTechServiceTO;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.StringHelper;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechnicalServiceBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private TechnicalServiceTO techService;
    private List<PersonToTechServiceTO> personRoles;
    private List<OrgToTechServiceTO> organizationRoles;
    private List<EndpointTO> endpoints;
    private String name;
    private String purpose;
    private List<KeyedRefTO> categories;
    private String wsdlUrl;
    private List<ServiceSpecificationTO> specsTO;
    private List<SimpleFileTO> relatedDocsTO;
    private List<String> selectedCategories;
    private int myRating;
    private float globalRating;
    private Set<String> tags = new HashSet();
    private List<CommentTO> comments;
    private String newComment;

    public void setMyRating(int rating) {
        this.myRating = rating;
    }

    public int getMyRating() {
        return this.myRating;
    }

    public void setGlobalRating(float globalRating) {
        this.globalRating = globalRating;
    }

    public void setGlobalRating(String globalRating) {
        this.globalRating = Float.parseFloat(globalRating);
    }

    public String getGlobalRating() {
        String toPrint = Float.toString(this.globalRating);
        return toPrint.substring(0, 3);
    }

    public void setTags(String tags) {
        String[] pieces = tags.split(",");
        for (int i = 0; i <= pieces.length - 1; ++i) {
            pieces[i] = pieces[i].trim();
            if (StringHelper.isNullOrEmpty((String)pieces[i])) continue;
            this.tags.add(pieces[i]);
        }
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags.toString();
    }

    public String getNewComment() {
        return this.newComment;
    }

    public void setNewComment(String newComment) {
        this.newComment = newComment;
    }

    public List<CommentTO> getComments() {
        return this.comments;
    }

    public void setComments(List<CommentTO> comments) {
        this.comments = comments;
    }

    public String addComment(String user) throws LocalizedError {
        String cmtTemp = this.newComment.trim();
        if (!StringHelper.isNullOrEmpty((String)cmtTemp)) {
            CommentTO newCommentTO = new CommentTO();
            newCommentTO.setContent(this.newComment);
            newCommentTO.setUserName(user);
            newCommentTO.setDate(new Date());
            try {
                DragonServiceFactory.getInstance().getTechServiceManager().updateComments(this.techService.getId(), newCommentTO);
                TechnicalServiceTO techServiceTemp = DragonServiceFactory.getInstance().getTechServiceManager().getTechService(this.techService.getId(), null);
                this.comments = techServiceTemp.getComments();
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        this.newComment = "";
        return "success";
    }

    public String removeComment(HttpServletRequest request) throws LocalizedError {
        String id = request.getParameter("comment");
        try {
            DragonServiceFactory.getInstance().getTechServiceManager().removeComment(this.techService.getId(), id);
            TechnicalServiceTO techServiceTemp = DragonServiceFactory.getInstance().getTechServiceManager().getTechService(this.techService.getId(), null);
            this.comments = techServiceTemp.getComments();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String id = iRequest.getParameter("serviceId");
        String user = iRequest.getUserPrincipal().getName();
        try {
            this.techService = DragonServiceFactory.getInstance().getTechServiceManager().getTechService(id, user);
            this.loadOrgRoles();
            this.loadPersonRoles();
            this.loadEndpoints();
            this.loadServiceSpecs();
            this.loadRelatedDocs();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    public void addRelatedDoc(IFileUploadPart file) throws IError {
        try {
            DragonServiceFactory.getInstance().getTechServiceManager().registerRelatedDoc(this.techService.getId(), file.getFileContentType(), InputStreamUtil.getBytes((InputStream)file.getFileInputStream()), file.getFileName());
        }
        catch (DeploymentException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError("Document content type not supported.", "Supported types are: DOC, PDF, XML, HTML, XLS, PPT, TXT, RTF, ODT, ODS, ODP", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String removeRelatedDocument(String documentId) throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechServiceManager().removeRelatedDoc(this.techService.getId(), documentId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadRelatedDocs();
        return "success";
    }

    public String removeCategories() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechServiceManager().removeCategories(this.techService.getId(), this.selectedCategories);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadCategories();
        return "success";
    }

    private void loadEndpoints() throws DeploymentException, DragonDelegateException {
        this.endpoints = DragonServiceFactory.getInstance().getEndpointManager().getEndpointsByTechService(this.techService.getId(), this.createSortOption(SortCriteria.ENDPOINT_NAME, true));
    }

    public void loadServiceSpecs() throws LocalizedError {
        try {
            List result = DragonServiceFactory.getInstance().getWSDLImporter().getServSpecsForTechServ(this.techService.getId());
            if (result != null) {
                for (ServiceSpecificationTO serviceSpecificationTO : result) {
                    if (serviceSpecificationTO.getFileName() != null) continue;
                    serviceSpecificationTO.setFileName("wsdlFile.wsdl");
                }
            }
            this.specsTO = result;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadCategories() throws LocalizedError {
        try {
            this.categories = DragonServiceFactory.getInstance().getTechServiceManager().getCategoriesForTechServ(this.techService.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String loadRelatedDocs() throws LocalizedError {
        List result = null;
        try {
            result = DragonServiceFactory.getInstance().getTechServiceManager().getRelatedDocsForTechServ(this.techService.getId());
            if (result != null) {
                for (SimpleFileTO simpleFileTO : result) {
                    if (StringHelper.isNullOrEmpty((String)simpleFileTO.getFileName())) {
                        String suffix = ContentType.getRelatedSuffix((ContentType)ContentType.fromString((String)simpleFileTO.getFileType()));
                        simpleFileTO.setFileName("Document" + suffix);
                    }
                    if (!StringHelper.isNullOrEmpty((String)simpleFileTO.getTitle())) continue;
                    simpleFileTO.setTitle("NoTitle");
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.relatedDocsTO = result;
        return "success";
    }

    public String save() throws LocalizedError {
        TechnicalServiceTO newTechService = new TechnicalServiceTO();
        newTechService.setId(this.techService.getId());
        newTechService.setName(this.name);
        newTechService.setPurpose(this.purpose);
        RatingTO ratingTO = new RatingTO();
        ratingTO.setMyRating(this.myRating);
        ratingTO.setUserName(this.techService.getRatingTO().getUserName());
        ratingTO.setId(this.techService.getRatingTO().getid());
        newTechService.setRatingTO(ratingTO);
        newTechService.setTags(this.tags);
        newTechService.setComments(this.comments);
        try {
            DragonServiceFactory.getInstance().getTechServiceManager().updateTechService(newTechService);
            this.globalRating = DragonServiceFactory.getInstance().getTechServiceManager().updateGlobalRating(newTechService.getId());
            newTechService.setGlobalRating(this.globalRating);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.techService = newTechService;
        return "success";
    }

    public String create() throws LocalizedError {
        TechnicalServiceTO newTechService = new TechnicalServiceTO();
        newTechService.setName(this.name);
        newTechService.setPurpose(this.purpose);
        String techServiceId = "";
        RatingTO rating = new RatingTO();
        rating.setMyRating(this.myRating);
        rating.setUserName(this.techService.getRatingTO().getUserName());
        rating.setId("");
        newTechService.setRatingTO(rating);
        newTechService.setGlobalRating(this.globalRating);
        newTechService.setTags(this.tags);
        newTechService.setComments(this.comments);
        try {
            techServiceId = DragonServiceFactory.getInstance().getTechServiceManager().createTechService(newTechService);
            this.techService = DragonServiceFactory.getInstance().getTechServiceManager().getTechService(techServiceId, newTechService.getRatingTO().getUserName());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechServiceManager().removeTechService(this.techService.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        this.name = this.techService.getName();
        this.purpose = this.techService.getPurpose();
        this.categories = this.techService.getCategories();
        this.myRating = this.techService.getRatingTO().getMyRating();
        this.globalRating = this.techService.getGlobalRating();
        this.comments = this.techService.getComments();
        this.tags = this.techService.getTags();
    }

    public void clear() {
        this.techService = new TechnicalServiceTO();
        this.reset();
    }

    public void validate() {
    }

    public void loadPersonRoles() throws OrganizationException, DragonDelegateException {
        this.personRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getPersonRolesByTechService(this.techService.getId(), this.createSortOption(SortCriteria.LINK_TYPE, true));
    }

    public void loadOrgRoles() throws OrganizationException, DragonDelegateException {
        this.organizationRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getOrgRolesByTechService(this.techService.getId(), this.createSortOption(SortCriteria.LINK_TYPE, true));
    }

    public String deleteRole(HttpServletRequest request) throws LocalizedError {
        String roleToDeleteId = request.getParameter("roleToDeleteId");
        try {
            DragonServiceFactory.getInstance().getRoleOfPartyManager().removeRole(roleToDeleteId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.load(request);
        return "success";
    }

    public void loadRelatedDoc(HttpServletRequest request, HttpServletResponse response, String relatedDocId, String contentType) throws LocalizedError, IOException {
        InputStream input = null;
        try {
            input = DragonServiceFactory.getInstance().getTechServiceManager().getRelatedDocContent(relatedDocId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        ServletOutputStream output = response.getOutputStream();
        response.setContentType(contentType);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        byte[] buffer = new byte[512];
        int len = 0;
        while ((len = input.read(buffer)) >= 0) {
            output.write(buffer, 0, len);
        }
        output.flush();
        output.close();
    }

    public void loadWSDLDesc(HttpServletRequest request, HttpServletResponse response, String serviceSpecId) throws LocalizedError, IOException {
        InputStream input = null;
        try {
            input = DragonServiceFactory.getInstance().getWSDLImporter().getWsdlDesc(serviceSpecId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        ServletOutputStream output = response.getOutputStream();
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        byte[] buffer = new byte[512];
        int len = 0;
        while ((len = input.read(buffer)) >= 0) {
            output.write(buffer, 0, len);
        }
        output.flush();
        output.close();
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String getId() {
        if (this.techService == null) {
            return "";
        }
        return this.techService.getId();
    }

    public List<PersonToTechServiceTO> getPersonRoles() {
        return this.personRoles;
    }

    public List<OrgToTechServiceTO> getOrganizationRoles() {
        return this.organizationRoles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public List<EndpointTO> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<EndpointTO> endpoints) {
        this.endpoints = endpoints;
    }

    public List<ServiceSpecificationTO> getSpecsTO() {
        return this.specsTO;
    }

    public void setSpecsTO(List<ServiceSpecificationTO> specsTO) {
        this.specsTO = specsTO;
    }

    public List<SimpleFileTO> getRelatedDocsTO() {
        return this.relatedDocsTO;
    }

    public void setRelatedDocsTO(List<SimpleFileTO> relatedDocsTO) {
        this.relatedDocsTO = relatedDocsTO;
    }

    public TechnicalServiceTO getTechService() {
        return this.techService;
    }

    public void setTechService(TechnicalServiceTO techService) {
        this.techService = techService;
    }

    public List<String> getSelectedCategories() {
        return this.selectedCategories;
    }

    public void setSelectedCategories(List<String> selectedCategories) {
        this.selectedCategories = selectedCategories;
    }

    public List<KeyedRefTO> getCategories() {
        return this.categories;
    }

    public void setCategories(List<KeyedRefTO> categories) {
        this.categories = categories;
    }
}

