/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.TechnicalServiceBean;
import org.ow2.opensuit.core.error.LocalizedError;

public class OrgToTechServiceBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private OrgToTechServiceTO role;
    private String[] orgRoles;
    private String type;
    private String techServiceId;
    private String organizationId;

    public String addRoleToOrg(HttpServletRequest iRequest, TechnicalServiceBean techServiceBean) throws LocalizedError {
        this.techServiceId = iRequest.getParameter("serviceId");
        try {
            DragonServiceFactory.getInstance().getRoleOfPartyManager().createTechServiceRole(this.organizationId, this.techServiceId, this.type);
            techServiceBean.loadOrgRoles();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void loadOrgRoles() throws LocalizedError {
        try {
            this.orgRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getRolesTypes(RoleOfPartyManager.LINK_TYPE.ORG_TO_TECHSERVICE, null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void reset() {
        this.type = this.role.getType();
    }

    public void clear() {
        this.role = new OrgToTechServiceTO();
        this.reset();
    }

    public String getId() {
        if (this.role == null) {
            return "";
        }
        return this.role.getId();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTechServiceId() {
        return this.techServiceId;
    }

    public void setTechServiceId(String techServiceId) {
        this.techServiceId = techServiceId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String[] getOrgRoles() {
        return this.orgRoles;
    }

    public void setOrgRoles(String[] orgRoles) {
        this.orgRoles = orgRoles;
    }
}

