/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.api.Compensation;
import com.ebmwebsourcing.agreement.definition.api.Penalty;
import com.ebmwebsourcing.agreement.definition.api.Reward;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.ui.uibeans.sla.BusinessValueBean;
import org.ow2.dragon.ui.uibeans.sla.GuaranteeBean;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompensationBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final String TIME_INTERVAL = "duration";
    private static final String COUNT = "invocation number";
    private static final List<String> listValueType = new ArrayList<String>(Arrays.asList("duration", "invocation number"));
    private Compensation cTO;
    private int indice = -1;
    private String compensationType;
    private BusinessValueBean bvb;
    private ManagedAgreementBean mab;
    private String type;
    private long value;
    private String unit;
    private long quantity;

    public CompensationBean() {
    }

    public CompensationBean(int indice, Compensation compTO, BusinessValueBean bvb, ManagedAgreementBean mab, String compensationType) throws LocalizedError {
        this.bvb = bvb;
        this.mab = bvb.getMab();
        this.compensationType = compensationType;
        this.cTO = compTO;
        this.indice = indice;
        this.reset();
    }

    public void init(GuaranteeBean gb, String indice, String compensationType) throws LocalizedError {
        this.bvb = gb.getBusinessBean();
        this.mab = gb.getMab();
        this.compensationType = compensationType;
        this.indice = Integer.parseInt(indice);
        if (this.indice >= 0) {
            if (this.compensationType.equals("penalty")) {
                this.cTO = ((CompensationBean)gb.getBusinessBean().getPenalties().get(this.indice)).getCTO();
                gb.getBusinessBean().getPenalties().remove(this.indice);
                gb.getBusinessBean().getPenalties().add(this.indice, this);
            } else if (this.compensationType.equals("reward")) {
                this.cTO = ((CompensationBean)gb.getBusinessBean().getRewards().get(this.indice)).getCTO();
                gb.getBusinessBean().getRewards().remove(this.indice);
                gb.getBusinessBean().getRewards().add(this.indice, this);
            }
        } else {
            this.cTO = null;
        }
        this.reset();
    }

    public String save() throws LocalizedError {
        try {
            if (this.type.equals(TIME_INTERVAL)) {
                this.cTO.setTimeInterval(Long.valueOf(this.value));
            }
            if (this.type.equals(COUNT)) {
                this.cTO.setCount(Integer.valueOf(Integer.parseInt(String.valueOf(this.value))));
            }
            this.cTO.setValueExpr(this.unit);
            this.cTO.setValueUnit(String.valueOf(this.quantity));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String create(BusinessValueBean businessBean) throws LocalizedError {
        this.bvb = businessBean;
        this.mab = businessBean.getMab();
        try {
            if (this.compensationType.equals("penalty")) {
                this.cTO = businessBean.getBvTO().newPenalty();
                this.save();
                businessBean.getBvTO().addPenalty((Penalty)this.cTO);
                businessBean.getPenalties().add(new CompensationBean(businessBean.getPenalties().size(), this.cTO, this.bvb, this.mab, this.compensationType));
            } else {
                this.cTO = businessBean.getBvTO().newReward();
                this.save();
                businessBean.getBvTO().addReward((Reward)this.cTO);
                businessBean.getRewards().add(new CompensationBean(businessBean.getRewards().size(), this.cTO, this.bvb, this.mab, this.compensationType));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String delete() throws LocalizedError {
        if (this.cTO instanceof Penalty) {
            this.bvb.getBvTO().removePenalty((Penalty)this.cTO);
            this.bvb.getPenalties().remove(this.indice);
            int i = 0;
            for (CompensationBean comp : this.bvb.getPenalties()) {
                comp.setIndice(i);
                ++i;
            }
        } else {
            this.bvb.getBvTO().removeReward((Reward)this.cTO);
            this.bvb.getRewards().remove(this.indice);
            int i = 0;
            for (CompensationBean comp : this.bvb.getRewards()) {
                comp.setIndice(i);
                ++i;
            }
        }
        this.bvb.save();
        this.bvb = null;
        this.mab = null;
        this.compensationType = null;
        this.cTO = null;
        this.indice = -1;
        this.reset();
        return "success";
    }

    public void reset() {
        if (this.cTO != null) {
            if (this.cTO.getTimeInterval() != null) {
                this.value = this.cTO.getTimeInterval();
                this.type = TIME_INTERVAL;
            }
            if (this.cTO.getCount() != null) {
                this.value = this.cTO.getCount().intValue();
                this.type = COUNT;
            }
            this.unit = this.cTO.getValueExpr();
            if (this.cTO.getValueUnit() != null) {
                this.quantity = Float.valueOf(this.cTO.getValueUnit()).longValue();
            }
        } else {
            this.value = 0L;
            this.type = null;
            this.unit = null;
            this.quantity = 0L;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public Compensation getCTO() {
        return this.cTO;
    }

    public void setCTO(Compensation cto) {
        this.cTO = cto;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getCompensationType() {
        return this.compensationType;
    }

    public void setCompensationType(String compensationType) {
        this.compensationType = compensationType;
    }

    public static List<String> getListValueType() {
        return listValueType;
    }

    public int getIndice() {
        return this.indice;
    }

    public void setIndice(int indice) {
        this.indice = indice;
    }
}

