/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.api.GuaranteeTerms;
import com.ebmwebsourcing.agreement.definition.api.ServiceScope;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceRoleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.ui.uibeans.sla.BusinessValueBean;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.dragon.ui.uibeans.sla.QualifyingConditionBean;
import org.ow2.dragon.ui.uibeans.sla.ServiceLevelObjectiveBean;
import org.ow2.dragon.ui.uibeans.sla.ServiceSelectorBean;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuaranteeBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final List<String> listObligated = new ArrayList<String>(Arrays.asList(ServiceRoleType.SERVICE_PROVIDER.value(), ServiceRoleType.SERVICE_CONSUMER.value()));
    private GuaranteeTerms gTO;
    private ManagedAgreementBean mab;
    private String name;
    private String obligated;
    private ServiceLevelObjectiveBean sloBean = new ServiceLevelObjectiveBean();
    private BusinessValueBean businessBean = new BusinessValueBean();
    private List<ServiceSelectorBean> serviceScopesBean = new ArrayList();
    private QualifyingConditionBean qualifyingConditionBean = new QualifyingConditionBean();
    private List<String> selectedOperations = new ArrayList();

    public List<String> getSelectedOperations() {
        if (this.selectedOperations == null) {
            this.selectedOperations = new ArrayList();
        }
        return this.selectedOperations;
    }

    public void setSelectedOperations(List<String> selectedOperations) {
        this.selectedOperations = selectedOperations;
    }

    public GuaranteeBean() {
    }

    public GuaranteeBean(GuaranteeTerms gTO, ManagedAgreementBean mab) throws LocalizedError {
        this.gTO = gTO;
        this.mab = mab;
        this.businessBean.setBvTO(gTO.getBusinessValueList());
        this.businessBean.setMab(this.mab);
        this.businessBean.setGb(this);
        this.qualifyingConditionBean.setQcTO(gTO.getQualifyingCondition());
        this.qualifyingConditionBean.setMab(this.mab);
        this.qualifyingConditionBean.setGb(this);
        this.sloBean.setSloTO(gTO.getServiceLevelObjective());
        this.sloBean.setMab(this.mab);
        this.sloBean.setGb(this);
        this.initServiceScopeBean();
        this.reset();
    }

    private void initServiceScopeBean() {
        this.serviceScopesBean.clear();
        if (this.gTO != null) {
            for (ServiceScope sst : this.gTO.getServiceScopes()) {
                this.serviceScopesBean.add(new ServiceSelectorBean(sst, this, this.mab));
            }
        }
    }

    public void init(String idGuarantee, ManagedAgreementBean mab) throws LocalizedError {
        this.mab = mab;
        if (!idGuarantee.equals("-1")) {
            try {
                if (idGuarantee != null && this.mab.getAgreementBean().getGuaranteesBean() != null) {
                    for (GuaranteeBean g : this.mab.getAgreementBean().getGuaranteesBean()) {
                        if (!g.getName().equals(idGuarantee)) continue;
                        this.gTO = g.getGTO();
                        this.mab.getAgreementBean().getGuaranteesBean().remove(g);
                        this.mab.getAgreementBean().getGuaranteesBean().add(this);
                        break;
                    }
                }
                if (this.gTO == null) {
                    throw new LocalizedError("Impossible to find the guarantee named " + idGuarantee);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            this.initServiceScopeBean();
            this.businessBean.setBvTO(this.gTO.getBusinessValueList());
            this.businessBean.setMab(this.mab);
            this.businessBean.setGb(this);
            this.qualifyingConditionBean.setQcTO(this.gTO.getQualifyingCondition());
            this.qualifyingConditionBean.setMab(this.mab);
            this.qualifyingConditionBean.setGb(this);
            this.sloBean.setSloTO(this.gTO.getServiceLevelObjective());
            this.sloBean.setMab(this.mab);
            this.sloBean.setGb(this);
        } else {
            this.gTO = null;
            this.businessBean.setBvTO(null);
            this.businessBean.setMab(this.mab);
            this.businessBean.setGb(this);
            this.qualifyingConditionBean.setQcTO(null);
            this.qualifyingConditionBean.setMab(this.mab);
            this.qualifyingConditionBean.setGb(this);
            this.sloBean.setSloTO(null);
            this.sloBean.setMab(this.mab);
            this.sloBean.setGb(this);
            this.initServiceScopeBean();
        }
        this.reset();
    }

    public String save() throws LocalizedError {
        this.gTO.setName(this.name);
        this.gTO.setObligated(ServiceRoleType.fromValue((String)this.obligated));
        this.qualifyingConditionBean.save();
        this.sloBean.save();
        this.businessBean.save();
        for (ServiceSelectorBean s : this.serviceScopesBean) {
            s.save();
        }
        return "success";
    }

    public String delete(ManagedAgreementBean mab) throws LocalizedError {
        try {
            mab.getAgreementBean().getAgreementTO().getGuaranteeTerms().remove(this.gTO);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String deleteServiceScope(String name) throws LocalizedError {
        this.selectedOperations.remove(name);
        this.verifToAddOperationToGuarantee();
        return "success";
    }

    public String create(ManagedAgreementBean mab) throws LocalizedError {
        try {
            this.mab = mab;
            this.gTO = mab.getAgreementBean().getAgreementTO().newGuaranteeTerms();
            this.gTO.setBusinessValueList(this.gTO.newBusinessValueList());
            this.businessBean.setBvTO(this.gTO.getBusinessValueList());
            this.businessBean.setMab(this.mab);
            this.businessBean.setGb(this);
            this.gTO.setQualifyingCondition(this.gTO.newQualifyingCondition(null, null));
            this.qualifyingConditionBean.setQcTO(this.gTO.getQualifyingCondition());
            this.qualifyingConditionBean.setMab(this.mab);
            this.qualifyingConditionBean.setGb(this);
            this.gTO.setServiceLevelObjective(this.gTO.newServiceLevelObjective());
            this.gTO.getServiceLevelObjective().setKPITarget(this.gTO.getServiceLevelObjective().newKPITarget());
            this.gTO.getServiceLevelObjective().getKPITarget().setConstraint(this.gTO.getServiceLevelObjective().getKPITarget().newConstraint());
            this.gTO.getServiceLevelObjective().getKPITarget().getConstraint().setValue(this.gTO.getServiceLevelObjective().getKPITarget().getConstraint().newValue());
            this.gTO.getServiceLevelObjective().getKPITarget().getConstraint().getValue().setType(this.gTO.getServiceLevelObjective().getKPITarget().getConstraint().getValue().newType());
            this.gTO.getServiceLevelObjective().getKPITarget().getConstraint().getValue().setUnit(this.gTO.getServiceLevelObjective().getKPITarget().getConstraint().getValue().newUnit());
            this.sloBean.setSloTO(this.gTO.getServiceLevelObjective());
            this.sloBean.setMab(this.mab);
            this.sloBean.setGb(this);
            this.verifToAddOperationToGuarantee();
            mab.getAgreementBean().getAgreementTO().addGuarantee(this.gTO);
            mab.getAgreementBean().getGuaranteesBean().add(this);
            this.save();
            this.reset();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String verifToAddOperationToGuarantee() throws LocalizedError {
        try {
            boolean find = false;
            for (String operation : this.getSelectedOperations()) {
                find = false;
                for (ServiceSelectorBean ssb : this.serviceScopesBean) {
                    if (ssb.getValue() == null || !ssb.getValue().equals(operation)) continue;
                    find = true;
                }
                if (find) continue;
                ServiceScope ssTO = this.gTO.newServiceScope();
                ssTO.setScope(operation);
                ssTO.setServiceName(this.mab.getAgreementBean().getAgreementTO().getServiceReference().getServiceName());
                this.gTO.addServiceScope(ssTO);
                this.serviceScopesBean.add(new ServiceSelectorBean(ssTO, this, this.mab));
            }
            Iterator it = this.serviceScopesBean.iterator();
            while (it.hasNext()) {
                ServiceSelectorBean ssb = (ServiceSelectorBean)it.next();
                find = false;
                for (String operation : this.getSelectedOperations()) {
                    if (ssb.getValue() == null || !ssb.getValue().equals(operation)) continue;
                    find = true;
                }
                if (find) continue;
                this.gTO.removeServiceScope(ssb.getSsTO());
                this.serviceScopesBean.remove(ssb);
                it = this.serviceScopesBean.iterator();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() throws LocalizedError {
        if (this.gTO != null) {
            this.name = this.gTO.getName();
            if (this.gTO.getObligated() != null) {
                this.obligated = this.gTO.getObligated().value();
            }
        } else {
            this.name = null;
            this.obligated = ServiceRoleType.SERVICE_PROVIDER.value();
            this.selectedOperations.clear();
        }
        this.qualifyingConditionBean.reset();
        this.sloBean.reset();
        this.businessBean.reset();
        for (ServiceSelectorBean s : this.serviceScopesBean) {
            s.reset();
        }
    }

    public static List<String> getObligatedList() {
        return listObligated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BusinessValueBean getBusinessBean() {
        return this.businessBean;
    }

    public void setBusinessBean(BusinessValueBean business) {
        this.businessBean = business;
    }

    public String getObligated() {
        return this.obligated;
    }

    public void setObligated(String obligated) {
        this.obligated = obligated;
    }

    public List<ServiceSelectorBean> getServiceScopesBean() {
        return this.serviceScopesBean;
    }

    public void setServiceScopesBean(List<ServiceSelectorBean> serviceScope) {
        this.serviceScopesBean = serviceScope;
    }

    public ServiceLevelObjectiveBean getSloBean() {
        return this.sloBean;
    }

    public void setSloBean(ServiceLevelObjectiveBean slo) {
        this.sloBean = slo;
    }

    public GuaranteeTerms getGTO() {
        return this.gTO;
    }

    public QualifyingConditionBean getQualifyingConditionBean() {
        return this.qualifyingConditionBean;
    }

    public void setQualifyingConditionBean(QualifyingConditionBean qualifyingConditionBean) {
        this.qualifyingConditionBean = qualifyingConditionBean;
    }

    public ManagedAgreementBean getMab() {
        return this.mab;
    }

    public void setMab(ManagedAgreementBean mab) {
        this.mab = mab;
    }

    public void setGTO(GuaranteeTerms gto) {
        this.gTO = gto;
    }
}

