/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionEnvironmentBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private ExecutionEnvironmentTO executionEnvironmentTO;
    private List<EndpointTO> hostedEps;
    private ProcessorTO hostProcessor;
    private EnvironmentFederationTO parentFederation;
    private String execEnvId;
    private String name;
    private String ipv4Address;
    private String type;
    private String envType;

    public String load(HttpServletRequest request) throws LocalizedError {
        String id = request.getParameter("execEnvId");
        this.loadExecEnv(id);
        this.loadHostProcessor();
        this.loadHostFederation();
        this.loadHostedEps(id);
        this.reset();
        return "success";
    }

    private void loadHostFederation() throws LocalizedError {
        if (this.executionEnvironmentTO.getParentFederationId() != null) {
            try {
                this.parentFederation = DragonServiceFactory.getInstance().getTechnologyManager().getEnvironmentFederation(this.executionEnvironmentTO.getParentFederationId());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
    }

    private void loadHostProcessor() throws LocalizedError {
        if (this.executionEnvironmentTO.getHostProcessorId() != null) {
            try {
                this.hostProcessor = DragonServiceFactory.getInstance().getTechnologyManager().getProcessor(this.executionEnvironmentTO.getHostProcessorId());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
    }

    private void loadHostedEps(String id) throws LocalizedError {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.ENDPOINT_NAME);
        try {
            this.hostedEps = DragonServiceFactory.getInstance().getTechnologyManager().getEpsHostedOnExecEnv(id, requestOptionsTO);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    private void loadExecEnv(String id) throws LocalizedError {
        try {
            this.executionEnvironmentTO = DragonServiceFactory.getInstance().getTechnologyManager().getExecutionEnvironment(id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void reset() {
        if (this.executionEnvironmentTO != null) {
            this.ipv4Address = this.executionEnvironmentTO.getIpv4Address();
            this.name = this.executionEnvironmentTO.getName();
            this.envType = this.executionEnvironmentTO.getEnvType();
            this.type = this.executionEnvironmentTO.getType();
            this.execEnvId = this.executionEnvironmentTO.getNodeId();
        }
    }

    public void save() {
    }

    public void validate() {
    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeExecutionEnvironment(this.executionEnvironmentTO.getNodeId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String getExecEnvId() {
        return this.execEnvId;
    }

    public void setExecEnvId(String execEnvId) {
        this.execEnvId = execEnvId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ExecutionEnvironmentTO getExecutionEnvironmentTO() {
        return this.executionEnvironmentTO;
    }

    public void setExecutionEnvironmentTO(ExecutionEnvironmentTO executionEnvironmentTO) {
        this.executionEnvironmentTO = executionEnvironmentTO;
    }

    public List<EndpointTO> getHostedEps() {
        return this.hostedEps;
    }

    public void setHostedEps(List<EndpointTO> hostedEps) {
        this.hostedEps = hostedEps;
    }

    public ProcessorTO getHostProcessor() {
        return this.hostProcessor;
    }

    public void setHostProcessor(ProcessorTO hostProcessor) {
        this.hostProcessor = hostProcessor;
    }

    public EnvironmentFederationTO getParentFederation() {
        return this.parentFederation;
    }

    public void setParentFederation(EnvironmentFederationTO parentFederation) {
        this.parentFederation = parentFederation;
    }

    public String getEnvType() {
        return this.envType;
    }

    public void setEnvType(String envType) {
        this.envType = envType;
    }
}

