/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.technology.ProcessorSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfProcessorsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<ProcessorTO> processors;
    private String searchCriteria;
    private List<String> searchedProperties;

    public void loadAll() throws LocalizedError {
        try {
            this.processors = DragonServiceFactory.getInstance().getTechnologyManager().getAllProcessors(this.createSortOption(SortCriteria.PROCESSOR_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            List properties = this.convertSearchedProperties(searchedProperties);
            try {
                this.processors = DragonServiceFactory.getInstance().getTechnologyManager().searchProcessors(searchCriteria, properties, this.createSortOption(SortCriteria.PROCESSOR_NAME, true));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.processors == null || this.processors.size() == 0) {
                LocalizedError error = new LocalizedError("search_processor_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    private List<ProcessorSearchProperties> convertSearchedProperties(List<String> searchedProperties2) {
        ArrayList<ProcessorSearchProperties> result = new ArrayList<ProcessorSearchProperties>();
        for (String prop : searchedProperties2) {
            ProcessorSearchProperties propEnum = ProcessorSearchProperties.fromString((String)prop);
            if (propEnum == null) continue;
            result.add(propEnum);
        }
        return result;
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }

    public List<ProcessorTO> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<ProcessorTO> processors) {
        this.processors = processors;
    }
}

