/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.technology.TechnologyException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeManagerBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private ExecutionEnvironmentManagerTO execEnvManagerTO;
    private String runtimeManagerId;
    private String name;
    private String address;
    private List<ExecutionEnvironmentTO> execEnvs;

    public String load(HttpServletRequest request) throws LocalizedError {
        String id = request.getParameter("runtimeManagerId");
        this.loadRuntimeManager(id);
        this.loadExecEnvs(id);
        this.reset();
        return "success";
    }

    public void loadRuntimeManager(String id) throws LocalizedError {
        try {
            this.execEnvManagerTO = DragonServiceFactory.getInstance().getTechnologyManager().getRuntimeManager(id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadExecEnvs(String id) throws LocalizedError {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        try {
            this.execEnvs = DragonServiceFactory.getInstance().getTechnologyManager().getManagedExecEnv(id, requestOptionsTO);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void reset() {
        if (this.execEnvManagerTO != null) {
            this.address = this.execEnvManagerTO.getAddress();
            this.name = this.execEnvManagerTO.getName();
            this.runtimeManagerId = this.execEnvManagerTO.getExecEnvManagerId();
        }
    }

    public void save() {
    }

    public void validate() {
    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeRuntimeManager(this.execEnvManagerTO.getExecEnvManagerId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String synchronizeExecEnvs() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().synchronizeManagedExecEnv(this.runtimeManagerId);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        catch (TechnologyException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadExecEnvs(this.runtimeManagerId);
        return "success";
    }

    public String getRuntimeManagerId() {
        return this.runtimeManagerId;
    }

    public void setRuntimeManagerId(String runtimeManagerId) {
        this.runtimeManagerId = runtimeManagerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<ExecutionEnvironmentTO> getExecEnvs() {
        return this.execEnvs;
    }

    public void setExecEnvs(List<ExecutionEnvironmentTO> execEnvs) {
        this.execEnvs = execEnvs;
    }
}

