/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * LoggedMenu.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.bricks;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.expression.ExpressionUtils;
import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.base.html.IView;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
@XmlDoc("The menu that summarizes the user identity.")
@XmlElement
public class LoggedMenu implements IView, IInitializable {

    @XmlAttribute(name = "CssClass", required = false)
    private String cssClass = "Logged";

    @XmlChild(name = "Visible", required = false)
    private Expression visible;

    @XmlChild(name = "LoggedTitle")
    private Expression loggedTitle;

    @XmlChild(name = "LogoutTitle")
    private Expression logoutTitle;

    public void initialize(IInitializationSupport initSupport,
            IInstantiationContext instContext) {
		// --- check visible can be converted to a boolean
		ExpressionUtils.validateBooleanExpr(initSupport, instContext, this, "Visible", visible);
    }
    public boolean isVisible(HttpServletRequest iRequest) {
        if (visible == null)
            return true;
        try {
			return visible.invoke(iRequest, Boolean.class);
		} catch (Exception e) {
			return false;
		}
    }

    public void preRender(HttpServletRequest request) throws Exception {
        // TODO Auto-generated method stub

    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {

        boolean visible = isVisible(iRequest);
        if (!visible)
            return;

        String logged = ExpressionUtils.getMessage(loggedTitle, iRequest);
        String logout = ExpressionUtils.getMessage(logoutTitle, iRequest);

        PrintWriter iWriter = iResponse.getWriter();
        iWriter.print("<div class='");
        iWriter.print(cssClass);
        iWriter.print("'>");
        iWriter.println(HtmlUtils.encode2HTML(logged, false));
        iWriter.print(HtmlUtils.encode2HTML(iRequest.getUserPrincipal().getName(), false));
        iWriter.print(HtmlUtils.encode2HTML(" | ", false));
        iWriter.println("<a href='" + iRequest.getContextPath()
                + "/j_spring_security_logout' title='logout'>");
        iWriter.println(HtmlUtils.encode2HTML(logout, false));
        iWriter.println("</a>");
        iWriter.println("</div>");
    }
}
