/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EndpointManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.deployment;

import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeoutException;

import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class EndpointManagerImpl implements EndpointManager {

    private final EndpointManager endpointManager;

    public EndpointManagerImpl(ApplicationContext context) {
        super();
        this.endpointManager = (EndpointManager) context.getBean("endpointManager");
    }

    public List<EndpointTO> getAllEndpoints(RequestOptionsTO requestOptionsTO)
            throws DeploymentException {
        return endpointManager.getAllEndpoints(requestOptionsTO);
    }

    public EndpointTO getEndpoint(String endpointId, String user) throws DeploymentException {
        return endpointManager.getEndpoint(endpointId, user);
    }

    public List<EndpointTO> getEndpointsByBinding(String bindingId,
            RequestOptionsTO requestOptionsTO) throws DeploymentException {
        return endpointManager.getEndpointsByBinding(bindingId, requestOptionsTO);
    }

    public List<EndpointTO> getEndpointsByTechService(String techServiceId,
            RequestOptionsTO requestOptionsTO) {
        return endpointManager.getEndpointsByTechService(techServiceId, requestOptionsTO);
    }

    public void removeEndpoint(String endpointId) throws DeploymentException {
        endpointManager.removeEndpoint(endpointId);
    }

    public String updateEndpoint(EndpointTO endpointTO) throws DeploymentException {
        return endpointManager.updateEndpoint(endpointTO);
    }

    // Added By TIAR Abderrahmane for the community part.
    public List<EndpointTO> getEndpointsByTag(String tag) {
        return endpointManager.getEndpointsByTag(tag);
    }

    public void removeTag(String tag, String endpointId) {
        endpointManager.removeTag(tag, endpointId);
    }

    public void updateComments(String endpointId, CommentTO commentTO) {
        endpointManager.updateComments(endpointId, commentTO);
    }

    public float updateGlobalRating(String endpointId) {
        return endpointManager.updateGlobalRating(endpointId);
    }

    public void removeComment(String endpointId, String commentId) {
        endpointManager.removeComment(endpointId, commentId);
    }

    public List<KeyedRefTO> getCategoriesForEndpoint(String endpointId) throws DeploymentException {
        return endpointManager.getCategoriesForEndpoint(endpointId);
    }

    public void removeCategories(String techServiceId, List<String> categoryIds)
            throws DeploymentException {
        endpointManager.removeCategories(techServiceId, categoryIds);
    }

    public void addCategory(String endpointId, String categoryId, String categoryValueId)
            throws DeploymentException {
        endpointManager.addCategory(endpointId, categoryId, categoryValueId);
    }

    public void addCategory(String endpointId, String categoryId, String categoryValue,
            String categoryDesc) throws DeploymentException {
        endpointManager.addCategory(endpointId, categoryId, categoryValue, categoryDesc);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.EndpointManager#createEndpoint(
     * java.lang.String, java.lang.String, java.lang.String)
     */
    @Override
    public String createEndpoint(String epName, String epAddress, String servId)
            throws DeploymentException {

        return endpointManager.createEndpoint(epName, epAddress, servId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.EndpointManager#addServiceDefFile
     * (org.w3c.dom.Document, java.lang.String, java.lang.String, boolean)
     */
    @Override
    public String addServiceDefFile(Document wsdlDoc, String wsdlFileName, String endpointId,
            boolean storeEntities) throws DeploymentException, TimeoutException {
        return endpointManager.addServiceDefFile(wsdlDoc, wsdlFileName, endpointId, storeEntities);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.EndpointManager#addServiceDefFile
     * (java.net.URI, java.lang.String, java.lang.String, boolean)
     */
    @Override
    public String addServiceDefFile(URI wsdlURI, String wsdlFileName, String endpointId,
            boolean storeEntities) throws DeploymentException, TimeoutException {
        return endpointManager.addServiceDefFile(wsdlURI, wsdlFileName, endpointId, storeEntities);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.EndpointManager#removeServiceSpec
     * (java.lang.String, java.lang.String)
     */
    @Override
    public void removeServiceSpec(String endpointId, String serviceSpecificationId)
            throws DeploymentException {
        endpointManager.removeServiceSpec(endpointId, serviceSpecificationId);
    }
}
