/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RoleOfPartyManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.organization;

import java.util.List;

import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.OrgToEndpointTO;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.api.to.organization.PersonToTechServiceTO;
import org.springframework.context.ApplicationContext;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class RoleOfPartyManagerImpl implements RoleOfPartyManager {

    private RoleOfPartyManager roleOfPartyManager;

    public RoleOfPartyManagerImpl(ApplicationContext context) {
        super();
        this.roleOfPartyManager = (RoleOfPartyManager) context.getBean("roleOfPartyManager");
    }

    public String createTechServiceRole(String partyId, String technicalServiceId, String type)
            throws OrganizationException {
        return roleOfPartyManager.createTechServiceRole(partyId, technicalServiceId, type);
    }

    public List<OrgToTechServiceTO> getOrgRolesByTechService(String techServiceId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getOrgRolesByTechService(techServiceId, requestOptionsTO);
    }

    public List<PersonToTechServiceTO> getPersonRolesByTechService(String techServiceId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getPersonRolesByTechService(techServiceId, requestOptionsTO);
    }

    public String[] getRolesTypes(LINK_TYPE linkType, RequestOptionsTO options) {
        return roleOfPartyManager.getRolesTypes(linkType, options);
    }

    public void removeRole(String roleId) {
        roleOfPartyManager.removeRole(roleId);
    }

    public String createEndpointRole(String partyId, String endpointId, String type)
            throws OrganizationException {
        return roleOfPartyManager.createEndpointRole(partyId, endpointId, type);
    }

    public List<OrgToEndpointTO> getOrgRolesByEndpoint(String endpointId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getOrgRolesByEndpoint(endpointId, requestOptionsTO);
    }

    public List<PersonToEndpointTO> getPersonRolesByEndpoint(String endpointId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getPersonRolesByEndpoint(endpointId, requestOptionsTO);
    }

}
