/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * DatabaseAdminBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.administration;

import org.apache.log4j.Logger;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.springframework.util.StringUtils;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class DatabaseAdminBean {

    private Logger logger = Logger.getLogger(this.getClass());

    private String datasetLocation;

    public String loadDataset() throws LocalizedError {
        try {
            if (StringUtils.hasText(datasetLocation)) {
                DragonServiceFactory.getInstance().getDataLoader().loadDataSet(datasetLocation);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
        return "success";
    }

    public String loadDataset(IFileUploadPart file) throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getDataLoader().loadDataset(
                    file.getFileInputStream());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
        return "success";
    }

    public String submit() {
        return "success";
    }

    public String rebuildIndex() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getDataLoader().rebuildIndex();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
        return "success";
    }

    public String getDatasetLocation() {
        return datasetLocation;
    }

    public void setDatasetLocation(String datasetLocation) {
        this.datasetLocation = datasetLocation;
    }

}
