/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * AddEndpointCategoryBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.organization;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

/**
 * @author ofabre
 * 
 */
public class AddOrgIdentifierBean {

    private Logger logger = Logger.getLogger(AddOrgIdentifierBean.class);

    private String identifierId;

    private String identifierValue;

    private String identifierDesc;

    private List<IdentifierTO> identifiers = new ArrayList<IdentifierTO>();

    public void loadOrganizationIdentifiers() throws LocalizedError {
        try {
            identifiers = DragonServiceFactory.getInstance().getTModelManager()
                    .loadOrganizationIdentifierSystems();
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public String addIdentifierToOrg(String orgId) throws IError {
        try {
            DragonServiceFactory.getInstance().getOrganizationManager().addIdentifier(orgId,
                    identifierId, identifierValue, identifierDesc);
        } catch (OrganizationException e) {
            NonLocalizedError error = new NonLocalizedError(
                    "Can't add identifier to organization.", e.getMessage(), e);
            error.setType(IError.FUNCTIONAL_ERROR);
            throw error;
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

        return "success";
    }

    public String getIdentifierId() {
        return identifierId;
    }

    public void setIdentifierId(String identifierId) {
        this.identifierId = identifierId;
    }

    public String getIdentifierValue() {
        return identifierValue;
    }

    public void setIdentifierValue(String identifierValue) {
        this.identifierValue = identifierValue;
    }

    public String getIdentifierDesc() {
        return identifierDesc;
    }

    public void setIdentifierDesc(String identifierDesc) {
        this.identifierDesc = identifierDesc;
    }

    public List<IdentifierTO> getIdentifiers() {
        return identifiers;
    }

    public void setIdentifiers(List<IdentifierTO> identifiers) {
        this.identifiers = identifiers;
    }

}
