/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * AddPostToOrgBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.organization;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class AddPostToOrgBean {

    private Logger logger = Logger.getLogger(this.getClass());

    // ==========================================================
    // === Attributes
    // ==========================================================

    private List<String> postIds;

    // ==========================================================
    // === Control Methods
    // ==========================================================

    /**
     * Add a posts to an organization object with current attributes
     */
    public String addPostsToOrg(HttpServletRequest iRequest, OrganizationBean orgBean,
            ListOfPostsBean listOfPosts) throws LocalizedError {
        if (postIds != null) {
            try {
                // TODO improve it by adding a new method on OrgManager to add
                // multiple posts at once
                for (String postId : postIds) {
                    DragonServiceFactory.getInstance().getOrganizationManager().addPost(
                            orgBean.getId(), postId);
                }
                orgBean.loadOrganizationPosts();
                listOfPosts.loadFree(iRequest);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
            }
        }
        return "success";
    }

    // ==========================================================
    // === Attributes Getters & Setters
    // ==========================================================

    public List<String> getPostIds() {
        return postIds;
    }

    public void setPostIds(List<String> postIds) {
        this.postIds = postIds;
    }

}
