/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrgToTechServiceBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.organization;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.TechnicalServiceBean;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class OrgToTechServiceBean {

    private Logger logger = Logger.getLogger(this.getClass());

    // ==========================================================
    // === Attributes
    // ==========================================================
    private OrgToTechServiceTO role;

    private String[] orgRoles;

    private String type;

    private String techServiceId;

    private String organizationId;

    // ==========================================================
    // === Control Methods
    // ==========================================================

    /**
     * Add a role to a person object on a technical service object with current
     * attributes
     */
    public String addRoleToOrg(HttpServletRequest iRequest, TechnicalServiceBean techServiceBean)
            throws LocalizedError {
        techServiceId = iRequest.getParameter("serviceId");

        try {
            DragonServiceFactory.getInstance().getRoleOfPartyManager().createTechServiceRole(
                    organizationId, techServiceId, type);
            techServiceBean.loadOrgRoles();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

        return "success";
    }

    public void loadOrgRoles() throws LocalizedError {

        try {
            orgRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getRolesTypes(
                    RoleOfPartyManager.LINK_TYPE.ORG_TO_TECHSERVICE, null);

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    /**
     * Resets changes made to the current role attributes.
     */
    public void reset() {
        type = role.getType();
    }

    /**
     * Clears the role.
     */
    public void clear() {
        role = new OrgToTechServiceTO();
        reset();
    }

    // ==========================================================
    // === Attributes Getters & Setters
    // ==========================================================

    public String getId() {
        if (role == null)
            return "";
        return role.getId();
    }

    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return the techServiceId
     */
    public String getTechServiceId() {
        return techServiceId;
    }

    /**
     * @param techServiceId
     *            the techServiceId to set
     */
    public void setTechServiceId(String techServiceId) {
        this.techServiceId = techServiceId;
    }

    /**
     * @return the organizationId
     */
    public String getOrganizationId() {
        return organizationId;
    }

    /**
     * @param organizationId
     *            the organizationId to set
     */
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * @return the orgRoles
     */
    public String[] getOrgRoles() {
        return orgRoles;
    }

    /**
     * @param orgRoles
     *            the orgRoles to set
     */
    public void setOrgRoles(String[] orgRoles) {
        this.orgRoles = orgRoles;
    }

}
