/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PersonToEndpointBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.organization;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.EndpointBean;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class PersonToEndpointBean {

    private Logger logger = Logger.getLogger(this.getClass());

    // ==========================================================
    // === Attributes
    // ==========================================================
    private PersonToEndpointTO role;

    private String[] personRoles;

    private String type;

    private String personId;

    private String endpointId;

    private String organizationId;

    // ==========================================================
    // === Control Methods
    // ==========================================================

    /**
     * Add a role to a person object on a technical service object with current
     * attributes
     */
    public String addRoleToPerson(HttpServletRequest iRequest, EndpointBean endpointBean)
            throws LocalizedError {
        endpointId = iRequest.getParameter("endpointId");

        try {
            DragonServiceFactory.getInstance().getRoleOfPartyManager().createEndpointRole(personId,
                    endpointId, type);
            endpointBean.loadPersonRoles();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

        return "success";
    }

    public void loadPersonRoles() throws LocalizedError {

        try {
            personRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getRolesTypes(
                    RoleOfPartyManager.LINK_TYPE.PERSON_TO_ENDPOINT, null);

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    /**
     * Resets changes made to the current role attributes.
     */
    public void reset() {
        type = role.getType();
    }

    /**
     * Clears the role.
     */
    public void clear() {
        role = new PersonToEndpointTO();
        reset();
    }

    // ==========================================================
    // === Attributes Getters & Setters
    // ==========================================================

    public String getId() {
        if (role == null)
            return "";
        return role.getId();
    }

    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return the personId
     */
    public String getPersonId() {
        return personId;
    }

    /**
     * @param personId
     *            the personId to set
     */
    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getEndpointId() {
        return endpointId;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    /**
     * @return the personRoles
     */
    public String[] getPersonRoles() {
        return personRoles;
    }

    /**
     * @param personRoles
     *            the personRoles to set
     */
    public void setPersonRoles(String[] personRoles) {
        this.personRoles = personRoles;
    }

    /**
     * @return the organizationId
     */
    public String getOrganizationId() {
        return organizationId;
    }

    /**
     * @param organizationId
     *            the organizationId to set
     */
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

}
