/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CompensationBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.Compensation;
import com.ebmwebsourcing.agreement.definition.api.Penalty;
import com.ebmwebsourcing.agreement.definition.api.Reward;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class CompensationBean {

	private Logger logger = Logger.getLogger(this.getClass());

	private static final String TIME_INTERVAL = "duration";

	private static final String COUNT = "invocation number";

	private static final List<String> listValueType = new ArrayList<String>(Arrays
			.asList(new String[] { TIME_INTERVAL, COUNT }));

	// ==========================================================
	// === Attributes
	// ==========================================================
	private Compensation cTO;
	
	private int indice = -1;

	// penalty or reward
	private String compensationType;

	private BusinessValueBean bvb;

	private ManagedAgreementBean mab;

	// TimeInterval or Count
	private String type;

	private long value;

	private String unit;

	private long quantity;

	/**
	 * Default constructor
	 * 
	 */
	public CompensationBean() {
	}

	/**
	 * Constructor
	 * @throws LocalizedError 
	 */
	public CompensationBean(int indice, Compensation compTO, BusinessValueBean bvb, ManagedAgreementBean mab, String compensationType) throws LocalizedError {
		this.bvb = bvb;
		this.mab = bvb.getMab();
		this.compensationType = compensationType;
		this.cTO = compTO;
		this.indice = indice;
		reset();
	}

	// ==========================================================
	// === Control Methods
	// ==========================================================

	public void init(GuaranteeBean gb, String indice, String compensationType) throws LocalizedError {
		
		this.bvb = gb.getBusinessBean();
		this.mab = gb.getMab();
		this.compensationType = compensationType;
		this.indice = Integer.parseInt(indice);
		
		if(this.indice >= 0) {
			if(this.compensationType.equals("penalty")) {
					this.cTO = gb.getBusinessBean().getPenalties().get(this.indice).getCTO();
					
					// change bean
					gb.getBusinessBean().getPenalties().remove(this.indice);
					gb.getBusinessBean().getPenalties().add(this.indice, this);
			} else if(this.compensationType.equals("reward")) {
					this.cTO = gb.getBusinessBean().getRewards().get(this.indice).getCTO();
					
					// change bean
					gb.getBusinessBean().getRewards().remove(this.indice);
					gb.getBusinessBean().getRewards().add(this.indice, this);
			} 
			
			
			
		} else {
			this.cTO = null;;
		}
		reset();
	}

	public String save() throws LocalizedError {
		try {
			if (this.type.equals("duration")) {
				cTO.setTimeInterval(this.value);
			}
			if (this.type.equals("invocation number")) {
				cTO.setCount(Integer.parseInt(String.valueOf(this.value)));
			}

			cTO.setValueExpr(this.unit);

			cTO.setValueUnit(String.valueOf(this.quantity));
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}

		return "success";
	}

	/**
	 * Creates an object with current attributes
	 */
	public String create(BusinessValueBean businessBean) throws LocalizedError {
		this.bvb = businessBean;
		this.mab = businessBean.getMab();
		try {
			if (this.compensationType.equals("penalty")) {
				cTO = businessBean.getBvTO().newPenalty();
				this.save();
				businessBean.getBvTO().addPenalty((Penalty) cTO);
				businessBean.getPenalties().add(new CompensationBean(businessBean.getPenalties().size(), cTO, this.bvb, this.mab, this.compensationType));
			} else {
				cTO = businessBean.getBvTO().newReward();
				this.save();
				businessBean.getBvTO().addReward((Reward) cTO);
				businessBean.getRewards().add(new CompensationBean(businessBean.getRewards().size(), cTO, this.bvb, this.mab, this.compensationType));
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}
		return "success";
	}

	/**
	 * Deletes the current endpoint from the database
	 */
	public String delete() throws LocalizedError {
		if(this.cTO instanceof Penalty) {
			this.bvb.getBvTO().removePenalty((Penalty) this.cTO);
			this.bvb.getPenalties().remove(this.indice);
			
			// reaffect all indice
			int i = 0;
			for (CompensationBean comp : this.bvb.getPenalties()) {
				comp.setIndice(i);
				i++;
			}
			
		} else {
			this.bvb.getBvTO().removeReward((Reward) this.cTO);
			this.bvb.getRewards().remove(this.indice);
			
			// reaffect all indice
			int i = 0;
			for (CompensationBean comp : this.bvb.getRewards()) {
				comp.setIndice(i);
				i++;
			}
		}
		
		// save
		this.bvb.save();
		
		// clear all
		this.bvb = null;
		this.mab = null;
		this.compensationType = null;
		this.cTO = null;
		this.indice = -1;
		reset();
		
		return "success";
	}

	/**
	 * Resets changes made to the current endpoint attributes.
	 */
	public void reset() {
		if (cTO != null) {
			if (cTO.getTimeInterval() != null) {
				this.value = cTO.getTimeInterval();
				this.type = "duration";
			}
			if (cTO.getCount() != null) {
				this.value = cTO.getCount();
				this.type = "invocation number";
			}

			this.unit = cTO.getValueExpr();

			if(cTO.getValueUnit() != null) {
				this.quantity = Float.valueOf(cTO.getValueUnit()).longValue();
			}
		} else {
			this.value = 0;
			this.type = null;
			this.unit = null;
			this.quantity = 0;
		}
	}


	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the value
	 */
	public long getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(long value) {
		this.value = value;
	}

	/**
	 * @return the cTO
	 */
	public Compensation getCTO() {
		return cTO;
	}

	/**
	 * @param cto
	 *            the cTO to set
	 */
	public void setCTO(Compensation cto) {
		cTO = cto;
	}

	/**
	 * @return the quantity
	 */
	public long getQuantity() {
		return quantity;
	}

	/**
	 * @param quantity
	 *            the quantity to set
	 */
	public void setQuantity(long quantity) {
		this.quantity = quantity;
	}

	/**
	 * @return the unit
	 */
	public String getUnit() {
		return unit;
	}

	/**
	 * @param unit
	 *            the unit to set
	 */
	public void setUnit(String unit) {
		this.unit = unit;
	}

	/**
	 * @return the compensationType
	 */
	public String getCompensationType() {
		return compensationType;
	}

	/**
	 * @param compensationType
	 *            the compensationType to set
	 */
	public void setCompensationType(String compensationType) {
		this.compensationType = compensationType;
	}

	/**
	 * @return the listValueType
	 */
	public static List<String> getListValueType() {
		return listValueType;
	}

	public int getIndice() {
		return indice;
	}

	public void setIndice(int indice) {
		this.indice = indice;
	}


}
