/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceReferenceBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.ServiceReference;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class ServiceReferenceBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private ServiceReference srTO;

	private ManagedAgreementBean mab;

	private String name;

	private String serviceName;


	public ServiceReferenceBean() {

	}

	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads a technical service from the request parameter 'id'.
	 */
	public ServiceReferenceBean(ServiceReference srTO, ManagedAgreementBean mab) {
		this.srTO = srTO;
		this.mab = mab;
		reset();
	}

	public String save() throws LocalizedError {
		srTO.setName(this.name);
		srTO.setServiceName(this.serviceName);
		return "success";
	}


	/**
	 * Resets changes made to the current endpoint attributes.
	 */
	public void reset() {
		if (srTO != null) {
			this.name = srTO.getName();
			this.serviceName = srTO.getServiceName();
		}
	}


	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	/**
	 * @return the srTO
	 */
	public ServiceReference getSrTO() {
		return srTO;
	}

	/**
	 * @param srTO
	 *            the srTO to set
	 */
	public void setSrTO(ServiceReference srTO) {
		this.srTO = srTO;
	}

	public ManagedAgreementBean getMab() {
		return mab;
	}

	public void setMab(ManagedAgreementBean mab) {
		this.mab = mab;
	}

}
