/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * WsdlBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.specification;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class WsdlBean {

    private Logger logger = Logger.getLogger(this.getClass());

    // ==========================================================
    // === Attributes
    // ==========================================================
    private String wsdlDesc;

    // ==========================================================
    // === Control Methods
    // ==========================================================
    /**
     * Loads an endpoint from the request parameter 'id'.
     */
    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String servSpecId = iRequest.getParameter("servSpecId");
        try {
            wsdlDesc = StringHelper.prettyPrint(DragonServiceFactory.getInstance()
                    .getWSDLImporter().getWsdlDescAsString(servSpecId));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public String getWsdlDesc() {
        return wsdlDesc;
    }

    public void setWsdlDesc(String wsdlDesc) {
        this.wsdlDesc = wsdlDesc;
    }

}
