/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EnvironmentFederationBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class EnvironmentFederationBean {

    private Logger logger = Logger.getLogger(this.getClass());

    private EnvironmentFederationTO environmentFederationTO;

    private String environmentFederationId;

    private String name;

    private String pattern;

    private List<ExecutionEnvironmentTO> execEnvs;

    public String load(HttpServletRequest request) throws LocalizedError {

        String id = request.getParameter("envFedId");

        // Load Runtime manager
        loadEnvironmentFederation(id);

        // Loas Runtime manager exec envs
        loadExecEnvs(id);

        reset();
        return "success";
    }

    public void loadEnvironmentFederation(String id) throws LocalizedError {
        try {
            environmentFederationTO = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getEnvironmentFederation(id);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

    }

    public void loadExecEnvs(String id) throws LocalizedError {
        // sort ascendingly on name
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        try {
            execEnvs = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getExecEnvsInFederation(id, requestOptionsTO);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

    }

    public void reset() {
        if (environmentFederationTO != null) {
            this.pattern = environmentFederationTO.getPattern();
            this.name = environmentFederationTO.getName();
            this.environmentFederationId = environmentFederationTO.getEnvFedId();
        }
    }

    public void save() {

    }

    public void validate() {

    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeEnvironmentFederation(
                    environmentFederationTO.getEnvFedId());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    // public String synchronizeExecEnvs() throws LocalizedError {
    // // Synchronize
    // try {
    // DragonServiceFactory.getInstance().getTechnologyManager().synchronizeExecEnvsInFederation(
    // environmentFederationId);
    // } catch (DragonDelegateException e) {
    // logger.error(e.getMessage(), e);
    // throw new LocalizedError("database_technical", new Object[] {
    // e.getMessage() });
    // } catch (TechnologyException e) {
    // logger.error(e.getMessage(), e);
    // throw new LocalizedError("database_technical", new Object[] {
    // e.getMessage() });
    // }
    //
    // // Reload list of exec envs
    // loadExecEnvs(environmentFederationId);
    //
    // return "success";
    // }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ExecutionEnvironmentTO> getExecEnvs() {
        return execEnvs;
    }

    public void setExecEnvs(List<ExecutionEnvironmentTO> execEnvs) {
        this.execEnvs = execEnvs;
    }

    public EnvironmentFederationTO getEnvironmentFederationTO() {
        return environmentFederationTO;
    }

    public void setEnvironmentFederationTO(EnvironmentFederationTO environmentFederationTO) {
        this.environmentFederationTO = environmentFederationTO;
    }

    public String getEnvironmentFederationId() {
        return environmentFederationId;
    }

    public void setEnvironmentFederationId(String environmentFederationId) {
        this.environmentFederationId = environmentFederationId;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

}
