package org.ow2.dragon.ui.bricks;

/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 France Telecom, http://www.francetelecom.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
import java.io.PrintWriter;
import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.expression.ExpressionUtils;
import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.opensuit.core.util.ReflectionHelper;
import org.ow2.opensuit.core.util.ReflectionHelper.NumberOutOfBoundsException;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.base.html.form.FormRenderingContext;
import org.ow2.opensuit.xml.base.html.form.FormSubmitContext;
import org.ow2.opensuit.xml.base.html.form.field.BaseSingleValueField;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlChildren;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/**
 * @author atiar (Abderrahmane TIAR)
 * @version 1.0
 */

@XmlDoc("A Sliding markup form field.<br/>" +
"Supported value types are: any String type or class." +
"<br/>" + "It's been used only for Strings in the \"String1, String2 ...\" format." +
"<br/> Possible parameter to add, a delimiter character between different elements " +
"in the String.")
@XmlElement
public class SlidingField extends BaseSingleValueField implements IInitializable
{
    
    @XmlDoc("Defines the page to show if an element is clicked on the list")
    @XmlAttribute(name="Page", required=true)
    protected String page ;
    
    @XmlDoc("Defines the name of the page parameter to show if an element is clicked on the list")
    @XmlAttribute(name="Param", required=true)
    protected String param ;
    
    @XmlDoc("Defines if there is a horizental list (from a Set) to show before the text field. default value: ${false}") 
    @XmlChildren(name="List")
    protected Expression list;
    
    @XmlDoc("Defines the name of the reference to click on before sliding the field. default value: ShowHide")  
    @XmlChild(name="ReferenceName", required=false)
    protected Expression ref;
    
    @XmlDoc("Defines the name of the Button inside the Sliding Field. default value: Add") 
    @XmlChild(name="ButtonName", required=false)
    protected Expression button;
    
    @XmlDoc("The help Sentence to show in the Sliding Field.")
    @XmlChild(name="HelpSentence", required=false)
    protected Expression helpSentence ;
    
    private Class<?> bindingType;

    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext)    {
        super.initialize(initSupport, instContext);

        if(initSupport.initialize(bind))
        {
            bindingType = bind.getType();

            // --- check binding type
            if(!bind.isConvertible(String.class))
                initSupport.addValidationMessage(this, "Bind", IInitializationSupport.ERROR, "Expression "+bind+" has invalid " +
                		"type ("+bind.getType()+"): String expected.");
        }
    }
    
    public Type getValueGenericType()
    {
        return getValueType();
    }
    public Class<?> getValueType()
    {
        if(bindingType != null)
            return bindingType;
        return String.class;
    }

    protected Object getValueFromRequest(HttpServletRequest iRequest, FormSubmitContext submitContext) throws ValidationError
    {
        String val = submitContext.getSubmitValue(getFieldName());
        try
        {
            return ReflectionHelper.parse2Type(val, bind.getType());
        }
        catch(NumberFormatException e)
        {
            throw new LocalizedValidationError("validation.int.not_a_string", "opensuit");
        }
        catch(NumberOutOfBoundsException e)
        {
            throw new LocalizedValidationError("validation.int.out_of_bounds", "opensuit", new Object[]{e.getMin(), e.getMax()});
        }
    }
    public void preRender(HttpServletRequest iRequest) throws Exception
    {
    }
    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
    {
        PrintWriter iWriter = iResponse.getWriter();
        boolean editable = iContext.isEditable() && isEditable(iRequest);
        boolean editMode = iContext.isEditMode() ;

        String val = null;
        
        if(editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction())
        {
            // --- after a submit: retrieve value from the request
            val = iContext.getSubmitContext().getSubmitValue(getFieldName());
        }
        else
        {
            // --- first display: retrieve value from the bean
            val = String.valueOf(bind.invoke(iRequest));
        }
        if(val == null)
            // --- intialisation � vide
            val = "";
        
        boolean list_ = ExpressionUtils.getBoolean(list , iRequest) ;
        // Beginning of writing in the response
        
        // Edit mode first,
        // in this case, we write all the element. 
        if (editMode) {
            // Calling the JavaScript File
            HtmlUtils.includeJavaScript(iRequest, iResponse, "org/ow2/dragon/ui/js/SlidingField.js");

            // The list references. will be initialized if list is on true.
            String references = "";
            
            // To transform the String to pieces containing the tags' names,
            // if we apply toString method on a HashSet, we get: [element1, element2,...]
            // If the boolean list is true
            if ( list_ == true) { 
                // Empty value is used to control the look of the div: SlidingDiv.
                // There is a difference between an empty list and 
                boolean emptyValue = false ;
                if (val.compareTo("[]") == 0) {
                    
                    // For the moment, we use the String "No tags."
                    // If we want to be more generic, we can specify 
                    // a new parameter in this component,
                    // Or just use "No elements." instead.
                    references = "No tags." ;
                    emptyValue = true ;
                } else {
                    String[] pieces = val.split( "," );
                    // removing [ and ] of HashSet.toString
                    pieces[0] = pieces[0].substring(1);
                    int end = pieces.length-1;
                    pieces[end] = pieces[end].substring(0, pieces[end].length()-1) ;

                    for ( int i = 0 ; i <= end ; i ++ ) {
                        // initializing references.
                        // we use the page and param specified in the component for the hyperlink
                        references = references + "<a href=\""+page+"?"+param+"="+pieces[i].trim()+"\" "+
                        "\" id =\"tag"+i+"\">"+pieces[i].trim()+"</a>";
                        if (i != end) {
                            references = references + ",\n" ;
                        }
                    }
                }

                // Writing down the references depending on the boolean emptyValue.
                iWriter.println("<div id=\"SlidingDiv\">");
                if (emptyValue) {
                    iWriter.println("<div id=\"fieldList\">") ;
                    iWriter.print(references) ;
                    iWriter.println("</div>");
                    iWriter.println("<br>");
                } else {
                    iWriter.print(references) ;
                    iWriter.println("<div id=\"fieldList\">") ;
                    iWriter.println("No tags to add.</div>");
                    iWriter.println("<br>");
                    // an other break.
                    iWriter.println("<br>");
                }
            }
            
            String id = bind.getID() ;
            
            // image for the reference to click on for sliding the div
            String plusUrl = "/dragon-ui/resources/img/menu/nornix-plus-node.gif" ;
            
            iWriter.println("<div id=\"controler\">");
            
            String ref_ = ExpressionUtils.getMessage(ref, iRequest)  ;
            
            if(ref_ == null) {
                ref_ = "ShowHide" ;
            }
            
            // Writing down the reference to click on to slide the div.
            iWriter.println("<a href=\"#\" onclick=\"slidedown_showHide('Addtext'); ShowTagsToAdd('fieldList','main_"+id+"');" +
            " return false;\" id =\"AddTag\"><img alt=\"\" src=\""+plusUrl+"\"/>"+ref_+"</a>") ;
            
            iWriter.println("</div>");
            
            iWriter.println("<div class=\"div_contentBox\" id=\"Addtext\">");
            
            iWriter.println("<div class = \"div_content\" id=\"subBox\">");

            // Writing down the help Sentence.
            String helpSentence_ = ExpressionUtils.getMessage(helpSentence, iRequest) ;
            if ( helpSentence_ != null) {
                iWriter.println("<div>") ;
                // help icon
                String helpUrl = "/dragon-ui/resources/img/menu/interrogation-point.png" ;
                iWriter.println("<img src=\""+helpUrl+"\"/>");
                iWriter.println(helpSentence_) ;
                iWriter.println("</div>") ;
            }
            
            // the text field to write down the new tags.
            iWriter.println("<input id=\"main_"+id+"\" type=\"text\" size=\"35\" onclick=\"setInput(main_"+id+");\" name=\""+id+"\"/>") ;
            
            String button_ = ExpressionUtils.getMessage(button, iRequest) ;
            
            if(button_ == null) {
                button_ = "Add" ;
            }
            
            // Writing down the button to click on to add the tags in the Field List, before saving definitely.
            iWriter.println("<input id=\"SlideButton\" type=\"submit\" onmouseout=\"style.backgroundColor='#f8f8f8'\""+
                    "value=\""+button_+"\" onclick=\"slidedown_showHide('Addtext');ShowTagsToAdd('fieldList','main_"+id+"');" +
                    " return false;\" onmouseover=\"style.backgroundColor='#dedede'\"/>");

            iWriter.println("</div>");
            iWriter.println("</div>");
            
            iWriter.println("</div>");

        } else {
            
            // Case where we're not in the edit mode.
            // Show only the elements "href" .
            if (list_ == true) {
                String references = "";
                if (val.compareTo("[]") == 0) {
                    references = "No tags." ;
                } else {
                    String[] pieces = val.split( "," );
                    // removing [ and ] of HashSet.toString()
                    pieces[0] = pieces[0].substring(1);
                    int end = pieces.length-1;
                    pieces[end] = pieces[end].substring(0, pieces[end].length()-1) ;

                    for ( int i = 0 ; i <= end ; i ++ ) {
                        // Use of the param and page
                        references = references + "<a href=\""+page+"?"+param+"="+pieces[i].trim()+"\" "+
                        "\" id =\"tag"+i+"\">"+pieces[i].trim()+"</a>";
                        if (i != end) {
                            references = references + ",\n" ;
                        }
                    }
                }

                iWriter.println("<div id=\"List\">");
                iWriter.println(references) ;
                iWriter.println("</div>");
            }

        }
    }
}