/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RoleGroupManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.administration;

import java.util.List;

import org.ow2.dragon.api.service.administration.RoleGroupException;
import org.ow2.dragon.api.service.administration.RoleGroupManager;
import org.ow2.dragon.api.to.administration.RoleGroupTO;
import org.springframework.context.ApplicationContext;

/**
 * @author strino - eBM WebSourcing
 * 
 */

public class RoleGroupManagerImpl implements RoleGroupManager

{
    private RoleGroupManager roleGroupManagerService;

    public RoleGroupManagerImpl(ApplicationContext context) {
        super();
        this.roleGroupManagerService = (RoleGroupManager) context.getBean("roleGroupManager");
    }
    
    public void init(){
        roleGroupManagerService.init();
    }
    
    public String createRoleGroup(RoleGroupTO roleTO)
    throws RoleGroupException {
        
        return roleGroupManagerService.createRoleGroup(roleTO);
    }
    
    public List<RoleGroupTO> getAllRoleGroup() throws RoleGroupException{
        
        return roleGroupManagerService.getAllRoleGroup();
    }
    public List<RoleGroupTO> getRoleGroupNotInUser (String idUser)
    throws RoleGroupException{
        
        return roleGroupManagerService.getRoleGroupNotInUser(idUser);
    }
    
    public RoleGroupTO getRoleGroup(String nameGroupe) throws RoleGroupException{
        
        return roleGroupManagerService.getRoleGroup(nameGroupe);
    }
    public void removeRoleGroup(String roleGroupId) throws RoleGroupException{
        roleGroupManagerService.removeRoleGroup(roleGroupId);
    }

    
    public String updateRoleGroup (RoleGroupTO groupeRolesTO)
    throws RoleGroupException {
        return roleGroupManagerService.updateRoleGroup(groupeRolesTO);
    }

    public void addUser(String idUser, String idRoleGroup) 
    throws RoleGroupException {
        roleGroupManagerService.addUser(idUser, idRoleGroup);
        
    }

    public void removeUser(String idUser, String idRoleGroup) 
    throws RoleGroupException {
       roleGroupManagerService.removeUser(idUser, idRoleGroup);
        
    }

}
    
    
    
