/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UserManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.administration;

import java.util.List;

import org.ow2.dragon.api.service.administration.UserException;
import org.ow2.dragon.api.service.administration.UserManager;
import org.ow2.dragon.api.to.administration.UserTO;
import org.springframework.context.ApplicationContext;

/**
 * @author strino - eBM WebSourcing
 * 
 */

public class UserManagerImpl implements UserManager 
{

    private UserManager userManagerService;
    
    public UserManagerImpl(ApplicationContext context){
        super();
        this.userManagerService = (UserManager) context.getBean("userManager");
   
    }
    
    public void init (){
        userManagerService.init();
    }
    
    public String createUser(UserTO arg0) throws UserException {
     
        return userManagerService.createUser(arg0);
    }
    
    public List<UserTO> getAllUser() throws UserException {
       
        return userManagerService.getAllUser();
    }
    
    public List<UserTO> getUserNotInRoleGroup(String arg0) throws UserException {
        
        return userManagerService.getUserNotInRoleGroup(arg0);
    }
    
    public UserTO getUser(String arg0) throws UserException {
     
        return userManagerService.getUser(arg0);
    }
    
    public UserTO getUserByLogin(String arg0) throws UserException {
       
        return userManagerService.getUserByLogin(arg0);
    }
    
    public void removeUser(String arg0) throws UserException {
       
        userManagerService.removeUser(arg0);
    }
    
    public String updateUser(UserTO arg0) throws UserException {
       
        return userManagerService.updateUser(arg0);
    }
    
    public void addRoleGroup(String arg0, String arg1) throws UserException {
       userManagerService.addRoleGroup(arg0, arg1);
        
    }

    public void removeRoleGroup(String arg0, String arg1) throws UserException {
        userManagerService.removeRoleGroup(arg0, arg1);
        
    }
}
