/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TechServiceManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.deployment;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeoutException;

import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.ServiceSearchProperties;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class TechServiceManagerImpl implements TechServiceManager {

    private final TechServiceManager techServiceManager;

    public TechServiceManagerImpl(ApplicationContext context) {
        super();
        this.techServiceManager = (TechServiceManager) context.getBean("techServiceManager");
    }

    public String createTechService(TechnicalServiceTO techServiceTO) throws DeploymentException {
        return techServiceManager.createTechService(techServiceTO);
    }

    public List<TechnicalServiceTO> getAllTechServices(RequestOptionsTO requestOptionsTO) {
        return techServiceManager.getAllTechServices(requestOptionsTO);
    }

    public TechnicalServiceTO getTechService(String techServiceId, String user)
            throws DeploymentException {
        return techServiceManager.getTechService(techServiceId, user);
    }

    public List<TechnicalServiceTO> loadServicesFromWSDL(String[] servicesId,
            RequestOptionsTO requestOptionsTO) throws DeploymentException {
        return techServiceManager.loadServicesFromWSDL(servicesId, requestOptionsTO);
    }

    public void removeTechService(String techServiceId) throws DeploymentException {
        techServiceManager.removeTechService(techServiceId);
    }

    /*
     * public List<TechnicalServiceTO> searchTechService(String searchCriteria,
     * boolean isSearchOnName, boolean isSearchOnCategory, boolean
     * isSearchOnOperations, boolean isSearchOnProtocol, boolean
     * isSearchOnPurpose, boolean isSearchOnOtherInfo, boolean
     * isSearchOnOrganization, boolean isSearchOnPerson, RequestOptionsTO
     * options) throws DeploymentException { return
     * techServiceManager.searchTechService(searchCriteria, isSearchOnName,
     * isSearchOnCategory, isSearchOnOperations, isSearchOnProtocol,
     * isSearchOnPurpose, isSearchOnOtherInfo, isSearchOnOrganization,
     * isSearchOnPerson, options); }
     */

    public String updateTechService(TechnicalServiceTO techServiceTO) throws DeploymentException {
        return techServiceManager.updateTechService(techServiceTO);
    }

    public EndpointTO getEndpoint(String techServiceName, String endpointName)
            throws DeploymentException {
        return techServiceManager.getEndpoint(techServiceName, endpointName);
    }

    public List<TechnicalServiceTO> searchTechService(String searchCriteria,
            List<ServiceSearchProperties> searchedProperties, RequestOptionsTO options)
            throws DeploymentException {
        return techServiceManager.searchTechService(searchCriteria, searchedProperties, options);
    }

    public String getRelatedDocContentAsString(String arg0) throws DeploymentException {
        return techServiceManager.getRelatedDocContentAsString(arg0);
    }

    public List<SimpleFileTO> getRelatedDocsForTechServ(String arg0) throws DeploymentException {
        return techServiceManager.getRelatedDocsForTechServ(arg0);
    }

    public InputStream getRelatedDocContent(String relatedDocId) throws DeploymentException {
        return techServiceManager.getRelatedDocContent(relatedDocId);
    }

    public String registerRelatedDoc(String serviceId, String mimetype, byte[] docContent,
            String fileName) throws DeploymentException {
        return techServiceManager.registerRelatedDoc(serviceId, mimetype, docContent, fileName);
    }

    public void removeRelatedDoc(String serviceId, String documentId) throws DeploymentException {
        techServiceManager.removeRelatedDoc(serviceId, documentId);
    }

    // Added By TIAR Abderrahmane for the community part.
    public float updateGlobalRating(String serviceId) {
        return techServiceManager.updateGlobalRating(serviceId);
    }

    public void updateComments(String serviceId, CommentTO comment) {
        techServiceManager.updateComments(serviceId, comment);
    }

    public List<TechnicalServiceTO> getTechServicesByTag(String tag) {
        return techServiceManager.getTechServicesByTag(tag);
    }

    public void removeTag(String tag, String serviceId) {
        techServiceManager.removeTag(tag, serviceId);
    }

    public void removeComment(String serviceId, String commentId) {
        techServiceManager.removeComment(serviceId, commentId);
    }

    public void removeCategories(String techServiceId, List<String> categoryIds)
            throws DeploymentException {
        techServiceManager.removeCategories(techServiceId, categoryIds);

    }

    public List<KeyedRefTO> getCategoriesForTechServ(String techServiceId)
            throws DeploymentException {
        return techServiceManager.getCategoriesForTechServ(techServiceId);
    }

    public void addCategory(String techServiceId, String categoryId, String categoryValueId)
            throws DeploymentException {
        techServiceManager.addCategory(techServiceId, categoryId, categoryValueId);
    }

    public void addCategory(String techServiceId, String categoryId, String categoryValue,
            String categoryDesc) throws DeploymentException {
        techServiceManager.addCategory(techServiceId, categoryId, categoryValue, categoryDesc);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.TechServiceManager#addServiceDefFile
     * (java.net.URI, java.lang.String, java.lang.String, boolean)
     */
    public String addServiceDefFile(URI wsdlURI, String wsdlFileName, String techServiceId,
            boolean storeEntities) throws DeploymentException, TimeoutException {

        return techServiceManager.addServiceDefFile(wsdlURI, wsdlFileName, techServiceId,
                storeEntities);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.TechServiceManager#addServiceDefFile
     * (org.w3c.dom.Document, java.lang.String, java.lang.String, boolean)
     */
    public String addServiceDefFile(Document wsdlDoc, String wsdlFileName, String techServiceId,
            boolean storeEntities) throws DeploymentException, TimeoutException {

        return techServiceManager.addServiceDefFile(wsdlDoc, wsdlFileName, techServiceId,
                storeEntities);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.TechServiceManager#removeServiceSpec
     * (java.lang.String, java.lang.String)
     */
    public void removeServiceSpec(String serviceId, String serviceSpecificationId)
            throws DeploymentException {
        techServiceManager.removeServiceSpec(serviceId, serviceSpecificationId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.deployment.TechServiceManager#addEndpoint(
     * java.lang.String, java.lang.String)
     */
    @Override
    public void addEndpoint(String endpointId, String serviceId) throws DeploymentException {
        techServiceManager.addEndpoint(endpointId, serviceId);

    }
}
