/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SLAManagerImpl.java
 * -------------------------------------------------------------------------
 */
package org.ow2.dragon.ui.businessdelegate.spring.sla;

import java.net.URI;
import java.util.List;

import org.ow2.dragon.api.service.sla.SLAManager;
import org.ow2.dragon.api.service.sla.SLAServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

/**
 * @author nsalatge - eBM WebSourcing
 *
 */
public class SLAManagerImpl implements SLAManager {

    private SLAManager manager;

    public SLAManagerImpl(ApplicationContext context) {
        super();
        this.manager = (SLAManager) context
                .getBean("slaManager");
    }

    public String importAgreementDefFile(Document domDocument) throws SLAServiceException  {
        return manager.importAgreementDefFile(domDocument);
    }

	public String createManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException {
		return manager.createManagedAgreement(managedAgreementTO);
	}

	public List<ManagedAgreementTO> getAllManagedAgreements(RequestOptionsTO requestOptionsTO) throws SLAServiceException {
		return manager.getAllManagedAgreements(requestOptionsTO);
	}

	public ManagedAgreementTO getManagedAgreement(String id) throws SLAServiceException {
		return manager.getManagedAgreement(id);
	}

	public void removeManagedAgreement(String agreementId) throws SLAServiceException {
		manager.removeManagedAgreement(agreementId);
	}

	public List<ManagedAgreementTO> searchManagedAgreement(String searchCriteria, List<String> searchedProperties, RequestOptionsTO iOptions) throws SLAServiceException {
		return manager.searchManagedAgreement(searchCriteria, searchedProperties, iOptions);
	}

	public String updateManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException {
		return manager.updateManagedAgreement(managedAgreementTO);
	}

    public List<ManagedAgreementTO> getAllManagedAgreementsFromEndpointId(String endpointId)
            throws SLAServiceException {
        return this.manager.getAllManagedAgreementsFromEndpointId(endpointId);
    }

    public List<ManagedAgreementTO> getAllManagedAgreementsFromServiceId(String serviceId)
            throws SLAServiceException {
        return this.manager.getAllManagedAgreementsFromServiceId(serviceId);
    }

    public String importAgreementDefFile(URI slaURI) throws SLAServiceException {
        return this.manager.importAgreementDefFile(slaURI);
    }


}
