/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * AddEndpointCategoryBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.deployment;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.util.StringHelper;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

/**
 * @author ofabre
 * 
 */
public class AddEndpointCategoryBean {

    private Logger logger = Logger.getLogger(AddEndpointCategoryBean.class);

    private String categoryId;

    private CategoryValueTO selectedCategory = new CategoryValueTO();

    private List<CategoryTO> categories = new ArrayList<CategoryTO>();

    private List<CategoryValueTO> categoryValues = new ArrayList<CategoryValueTO>();

    private boolean valueAvailable = false;

    public void loadEndpointCategories() throws LocalizedError {
        try {
            categories = DragonServiceFactory.getInstance().getTModelManager()
                    .loadEndpointCategories();
            categories.add(0, new CategoryTO("", "No Category selected", null));
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public void loadCategoryValues(String categoryId) throws LocalizedError {
        if (!StringHelper.isNullOrEmpty(categoryId)) {
            try {
                categoryValues = DragonServiceFactory.getInstance().getTModelManager()
                        .loadCategoryValues(categoryId);
                if (categoryValues != null && !categoryValues.isEmpty()) {
                    valueAvailable = true;
                } else {
                    valueAvailable = false;
                }
            } catch (DragonDelegateException e) {
                logger.error(e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
            }
        }
    }

    public List<CategoryTO> getCategories() {
        return categories;
    }

    public List<CategoryValueTO> getCategoryValues() {
        if (categoryValues == null || categoryValues.isEmpty()) {
            categoryValues.add(new CategoryValueTO("", "No category values", null));
        }
        return categoryValues;
    }

    public String addCategoryToEndpoint(String endpointId) throws IError {
        try {
            if (valueAvailable) {
                DragonServiceFactory.getInstance().getEndpointManager().addCategory(endpointId,
                        categoryId, selectedCategory.getId());
            } else {
                DragonServiceFactory.getInstance().getEndpointManager().addCategory(endpointId,
                        categoryId, selectedCategory.getValue(), selectedCategory.getDescription());
            }
        } catch (DeploymentException e) {
            NonLocalizedError error = new NonLocalizedError("Can't add category to endpoint.", e
                    .getMessage(), e);
            error.setType(IError.FUNCTIONAL_ERROR);
            throw error;
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

        return "success";
    }

    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setCategoryValues(List<CategoryValueTO> categoryValues) {
        this.categoryValues = categoryValues;
    }

    public CategoryValueTO getSelectedCategory() {
        return selectedCategory;
    }

    public void setSelectedCategory(CategoryValueTO selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public boolean isValueAvailable() {
        return valueAvailable;
    }

    public void setValueAvailable(boolean valueAvailable) {
        this.valueAvailable = valueAvailable;
    }

}
