/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ListOfAgreementsBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle.State;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class AgreementClientBoardBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private List<ManagedAgreementBean> agreementOffersNotSubmit = new ArrayList<ManagedAgreementBean>();

	private List<ManagedAgreementBean> agreementOffersPending = new ArrayList<ManagedAgreementBean>();

	private List<ManagedAgreementBean> submittedAgreements = new ArrayList<ManagedAgreementBean>();

	private List<ManagedAgreementBean> observedAgreements = new ArrayList<ManagedAgreementBean>();

	private List<ManagedAgreementBean> terminatedAgreements = new ArrayList<ManagedAgreementBean>();

	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads all organizations from the database
	 */
	public void load(HttpServletRequest iRequest) throws LocalizedError {
		try {
			agreementOffersNotSubmit = new ArrayList<ManagedAgreementBean>();
			agreementOffersPending = new ArrayList<ManagedAgreementBean>();
			submittedAgreements = new ArrayList<ManagedAgreementBean>();
			observedAgreements = new ArrayList<ManagedAgreementBean>();
			terminatedAgreements = new ArrayList<ManagedAgreementBean>();
			
			String clientId = iRequest.getParameter("personId");
			if(clientId.equals("-1")) {
				clientId = iRequest.getParameter("organizationId");
			}
			for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager()
					.getAllManagedAgreements(null)) {
				if((agTO.getIdClient() != null)&&(agTO.getIdClient().equals(clientId))&&
						(agTO.getAgreement() instanceof AgreementLifeCycle)){

					if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.OFFER_RECEIVE)) {
						agreementOffersNotSubmit.add(new ManagedAgreementBean(agTO));
					} else if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.PENDING)) {
						agreementOffersPending.add(new ManagedAgreementBean(agTO));
					} else if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.OBSERVE)) {
						observedAgreements.add(new ManagedAgreementBean(agTO));
					} else if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.REJECTE)) {
						terminatedAgreements.add(new ManagedAgreementBean(agTO));
					} else if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.TERMINATE)) {
						terminatedAgreements.add(new ManagedAgreementBean(agTO));
					} 
				}

			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}
	}

	public void reset() {

	}

	public List<ManagedAgreementBean> getAgreementOffersNotSubmit() {
		return agreementOffersNotSubmit;
	}

	public void setAgreementOffersNotSubmit(List<ManagedAgreementBean> agreementOffers) {
		this.agreementOffersNotSubmit = agreementOffers;
	}

	public List<ManagedAgreementBean> getAgreementOffersPending() {
		return agreementOffersPending;
	}

	public void setAgreementOffersPending(
			List<ManagedAgreementBean> agreementOffersPending) {
		this.agreementOffersPending = agreementOffersPending;
	}

	public List<ManagedAgreementBean> getSubmittedAgreements() {
		return submittedAgreements;
	}

	public void setSubmittedAgreements(
			List<ManagedAgreementBean> submittedAgreements) {
		this.submittedAgreements = submittedAgreements;
	}

	public List<ManagedAgreementBean> getObservedAgreements() {
		return observedAgreements;
	}

	public void setObservedAgreements(List<ManagedAgreementBean> observedAgreements) {
		this.observedAgreements = observedAgreements;
	}

	public List<ManagedAgreementBean> getTerminatedAgreements() {
		return terminatedAgreements;
	}

	public void setTerminatedAgreements(
			List<ManagedAgreementBean> terminatedAgreements) {
		this.terminatedAgreements = terminatedAgreements;
	}

}
