/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ListOfAgreementsBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class ListOfAgreementsBean {

    private Logger logger = Logger.getLogger(this.getClass());

    // ==========================================================
    // === Attributes
    // ==========================================================
    private List<ManagedAgreementBean> agreements = new ArrayList<ManagedAgreementBean>();

    private String fileDescriptionURL;

    private String searchCriteria;

    private boolean isSearchOnName;

    private boolean isSearchOnInitiator;

    private boolean isSearchOnResponder;

    private String selectedAgreementId;

    private String newLoadedAgreementId;

    private List<String> searchedProperties;

    // ==========================================================
    // === Control Methods
    // ==========================================================
    /**
     * Loads all organizations from the database
     */
    public void loadAll() throws LocalizedError {
        try {
            for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager()
                    .getAllManagedAgreements(createSortOption(SortCriteria.AGREEMENT_NAME, true))) {
                agreements.add(new ManagedAgreementBean(agTO));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public String loadNew() throws LocalizedError {

        try {
            newLoadedAgreementId = DragonServiceFactory.getInstance().getSLAManager()
                    .importAgreementDefFile(URI.create(fileDescriptionURL));
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
        return "success";
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    // ==========================================================
    // === Attributes Getters & Setters
    // ==========================================================

    /**
     * @return the agreements
     */
    public List<ManagedAgreementBean> getAgreements() {
        return agreements;
    }

    /**
     * @param agreements
     *            the agreements to set
     */
    public void setAgreements(List<ManagedAgreementBean> agreements) {
        this.agreements = agreements;
    }

    /**
     * @return the fileDescriptionURL
     */
    public String getFileDescriptionURL() {
        return fileDescriptionURL;
    }

    /**
     * @param fileDescriptionURL
     *            the fileDescriptionURL to set
     */
    public void setFileDescriptionURL(String fileDescriptionURL) {
        this.fileDescriptionURL = fileDescriptionURL;
    }

    /**
     * Searches agreement by name, type
     * 
     * public String search() throws LocalizedError { try { agreements = new
     * ArrayList<ManagedAgreementBean>(); for (ManagedAgreementTO agTO :
     * DragonServiceFactory.getInstance().getSLAManager()
     * .searchManagedAgreement(searchCriteria, isSearchOnName,
     * isSearchOnInitiator, isSearchOnResponder, null)) { agreements.add(new
     * ManagedAgreementBean(agTO)); } } catch (Exception e) {
     * logger.error(e.getMessage(), e); throw new
     * LocalizedError("database_technical", new Object[] { e.getMessage() }); }
     * if (this.agreements == null || this.agreements.size() == 0){
     * LocalizedError error = new LocalizedError("search_agreement_no_result");
     * //NonLocalizedError eroor = new NonLocalizedError("",)
     * error.setType(IError.FUNCTIONAL_ERROR); //error.setStackTrace(null);
     * throw error; }
     * 
     * return "several"; }
     */

    /**
     * Searches agreement by name, type
     */
    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List<String> searchedProperties = StringHelper
                    .urlParameterToArray(searchedPropertiesParam);
            try {
                agreements = new ArrayList<ManagedAgreementBean>();
                for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager()
                        .searchManagedAgreement(searchCriteria, searchedProperties,
                                createSortOption(SortCriteria.AGREEMENT_NAME, true))) {

                    agreements.add(new ManagedAgreementBean(agTO));
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
            }
            if (this.agreements == null || this.agreements.size() == 0) {
                LocalizedError error = new LocalizedError("search_agreement_no_result");
                // NonLocalizedError eroor = new NonLocalizedError("",)
                error.setType(IError.FUNCTIONAL_ERROR);
                // error.setStackTrace(null);
                throw error;
            }
        }
    }

    public boolean getIsSearchOnInitiator() {
        return isSearchOnInitiator;
    }

    public void setIsSearchOnInitiator(boolean isSearchOnInitiator) {
        this.isSearchOnInitiator = isSearchOnInitiator;
    }

    public boolean getIsSearchOnName() {
        return isSearchOnName;
    }

    public void setIsSearchOnName(boolean isSearchOnName) {
        this.isSearchOnName = isSearchOnName;
    }

    public boolean getIsSearchOnResponder() {
        return isSearchOnResponder;
    }

    public void setIsSearchOnResponder(boolean isSearchOnResponder) {
        this.isSearchOnResponder = isSearchOnResponder;
    }

    public String getSearchCriteria() {
        return searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    /**
     * @return the isEditable
     */
    public String getIsEditable(HttpServletRequest iRequest) {
        String editable = iRequest.getParameter("editable");
        return editable;
    }

    /**
     * @return the selectedIdAgreement
     */
    public String getSelectedAgreementId() {
        return selectedAgreementId;
    }

    /**
     * @param selectedAgreementId
     *            the selectedIdAgreement to set
     */
    public void setSelectedAgreementId(HttpServletRequest iRequest) {
        this.selectedAgreementId = iRequest.getParameter("agreementId");
    }

    /**
     * @param selectedAgreementId
     *            the selectedAgreementId to set
     */
    public void setSelectedAgreementId(String selectedAgreementId) {
        this.selectedAgreementId = selectedAgreementId;
    }

    public String setAgreementProcess(HttpServletRequest iRequest) {
        setSelectedAgreementId(iRequest);
        return getIsEditable(iRequest);
    }

    public String getNewLoadedAgreementId() {
        return newLoadedAgreementId;
    }

    public List<String> getSearchedProperties() {
        return searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }
}
