/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceDescriptionTermBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import java.net.URI;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.ServiceDescription;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class ServiceDescriptionTermBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private ServiceDescription sdtTO;

	private ManagedAgreementBean mab;

	private String name = null;

	private String providerName = null;

	private String serviceName = null;

	private String wsdlURL = null;


	public ServiceDescriptionTermBean() {

	}

	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads a technical service from the request parameter 'id'.
	 */
	public ServiceDescriptionTermBean(ServiceDescription sdtTO, ManagedAgreementBean mab) {
		this.sdtTO = sdtTO;
		this.mab = mab;
		reset();
	}

	public String save() throws LocalizedError {
		try {
			sdtTO.setName(this.name);
			sdtTO.setServiceName(this.serviceName);
			if(this.wsdlURL != null) {
				sdtTO.setWsdlDescription(new URI(this.wsdlURL));
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}

		return "success";
	}


	/**
	 * Resets changes made to the current endpoint attributes.
	 */
	public void reset() {
		if (sdtTO != null) {
			this.name = sdtTO.getName();
			this.serviceName = sdtTO.getServiceName();

			if(sdtTO.getWsdlDescription() != null) {
				this.wsdlURL = sdtTO.getWsdlDescription().toString();
			}
		}
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public String getWsdlURL() {
		return wsdlURL;
	}

	public void setWsdlURL(String wsdlURL) {
		this.wsdlURL = wsdlURL;
	}

	/**
	 * @return the sdtTO
	 */
	public ServiceDescription getSdtTO() {
		return sdtTO;
	}

	/**
	 * @param sdtTO
	 *            the sdtTO to set
	 */
	public void setSdtTO(ServiceDescription sdtTO) {
		this.sdtTO = sdtTO;
	}

	/**
	 * @return the providerName
	 */
	public String getProviderName() {
		return providerName;
	}

	/**
	 * @param providerName
	 *            the providerName to set
	 */
	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public ManagedAgreementBean getMab() {
		return mab;
	}

	public void setMab(ManagedAgreementBean mab) {
		this.mab = mab;
	}

}
