/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceSelectorBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.ServiceScope;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class ServiceSelectorBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private ServiceScope ssTO;

	private ManagedAgreementBean mab;
	
	private GuaranteeBean gb;

	private String value;

	/**
	 * Default constructor
	 * 
	 */
	public ServiceSelectorBean() {
	}

	/**
	 * Constructor
	 */
	public ServiceSelectorBean(ServiceScope ssTO, GuaranteeBean gb, ManagedAgreementBean mab) {
		this.ssTO = ssTO;
		this.mab = mab;
		this.gb = gb;
		reset();
	}

	// ==========================================================
	// === Control Methods
	// ==========================================================



	public String save() throws LocalizedError {
		if (ssTO != null) {
			ssTO.setScope(this.value);
		}

		return "success";
	}


	/**
	 * Deletes the current endpoint from the database
	 */
	public String delete(GuaranteeBean gBean) throws LocalizedError {
		gBean.getGTO().getServiceScopes().remove(this.ssTO);
		return "success";
	}

	/**
	 * Resets changes made to the current endpoint attributes.
	 */
	public void reset() {
		if (ssTO != null) {
			this.value = ssTO.getScope();
		} else {
			this.value = null;
		}
	}

	/**
	 * Clears the agreement.
	 */
	public void clear() {
		reset();
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return the ssTO
	 */
	public ServiceScope getSsTO() {
		return ssTO;
	}

	/**
	 * @param ssTO
	 *            the ssTO to set
	 */
	public void setSsTO(ServiceScope ssTO) {
		this.ssTO = ssTO;
	}

}
