/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * JBIBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla.env;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class JBIBean {

    private Logger logger = Logger.getLogger(this.getClass());

    // ==========================================================
    // === Attributes
    // ==========================================================
    private ManagedAgreementTO mTO;

    private String sujbi;

    private String probeSettings;

    private String agreementId = null;

    /**
     * @return the agreementId
     */
    public String getAgreementId() {
        return agreementId;
    }

    /**
     * @param agreementId
     *            the agreementId to set
     */
    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
    }

    /**
     * @return the probeSettings
     */
    public String getProbeSettings() {
        return probeSettings;
    }

    /**
     * @param probeSettings
     *            the probeSettings to set
     */
    public void setProbeSettings(String probeSettings) {
        this.probeSettings = probeSettings;
    }

    /**
     * Default constructor
     * 
     */
    public JBIBean() {
    }

    /**
     * Constructor
     * 
     * @throws LocalizedError
     * @throws DragonDelegateException
     */
    public JBIBean(ManagedAgreementTO mTO) throws LocalizedError {
        this.mTO = mTO;
        reset();
    }

    // ==========================================================
    // === Control Methods
    // ==========================================================

    /**
     * Loads a technical service from the request parameter 'id'.
     */
    public void load(HttpServletRequest iRequest) throws LocalizedError {
        agreementId = iRequest.getParameter("agreementId");
        try {
            if (agreementId != null) {
                mTO = DragonServiceFactory.getInstance().getSLAManager().getManagedAgreement(
                        agreementId);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
        reset();
    }

    /**
     * Resets changes made to the current endpoint attributes.
     * 
     * @throws DragonDelegateException
     */
    public void reset() throws LocalizedError {
        try {
            if (mTO != null) {
                this.agreementId = String.valueOf(mTO.getId());
//                this.sujbi = DragonServiceFactory.getInstance().getSLAManager().createJBIXml(mTO);
//                this.probeSettings = StringHelper.prettyPrint(DragonServiceFactory.getInstance()
//                        .getSLAManager().createProbeSettingsXml(mTO));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    /**
     * Clears the agreement.
     * 
     * @throws LocalizedError
     * @throws DragonDelegateException
     */
    public void clear() throws LocalizedError {
        mTO = new ManagedAgreementTO();
        reset();
    }

    /**
     * Validate the endpoint
     */
    public void validate() {

    }

    /**
     * @return the sujbi
     */
    public String getSujbi() {
        return sujbi;
    }

    /**
     * @param sujbi
     *            the sujbi to set
     */
    public void setSujbi(String sujbi) {
        this.sujbi = sujbi;
    }

}
