/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.bricks;

import java.io.PrintWriter;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.expression.ExpressionUtils;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.base.html.table.BaseColumn;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

@XmlDoc(value="A table column that displays rating in 5 stars format.")
@XmlElement
public class RatingColumn
extends BaseColumn
implements IInitializable {
    @XmlDoc(value="The value used to display the cell in stars format.<br>Supported contextual beans: $row")
    @XmlChild(name="Value", required=false)
    private Expression value;

    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        super.initialize(initSupport, instContext);
        if (this.value == null) {
            initSupport.addValidationMessage((Object)this, "Value", 1, "'Value' is required.");
        }
    }

    public Object getCellDisplayedContent(HttpServletRequest iRequest, Object iRowObject) throws Exception {
        if (this.value != null) {
            return ExpressionUtils.getMessage((Expression)this.value, (HttpServletRequest)iRequest);
        }
        return null;
    }

    public void renderCellContent(HttpServletRequest request, HttpServletResponse response, TableRenderingContext context, TableRenderingContext.ColumnDef column, int icol, Object rowObject) throws Exception {
        String textHtml;
        PrintWriter writer = response.getWriter();
        String sText = ExpressionUtils.getMessage((Expression)this.value, (HttpServletRequest)request);
        if (sText == null || sText.length() == 0) {
            textHtml = "&nbsp;";
        } else {
            int nbPixels = (int)(17.0f * Float.parseFloat(sText));
            textHtml = "<div id=\"star\"><ul id=\"star0\" class=\"star_column\"><li id=\"starCur0\" class=\"curr\" style=\"width: " + nbPixels + "px;margin-top:3px;\"></li>" + "</ul>" + "</div>";
        }
        writer.print(textHtml);
    }

    public Object getCellValue(HttpServletRequest iRequest, Object iRowObject) throws Exception {
        return ExpressionUtils.getMessage((Expression)this.value, (HttpServletRequest)iRequest);
    }

    public Class<?> getCellValueType() {
        return String.class;
    }

    public Type getCellValueGenericType() {
        return String.class;
    }
}

