/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.BindingOperationTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.RatingTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.organization.OrgToEndpointTO;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.organization.OrganizationBean;
import org.ow2.dragon.ui.uibeans.organization.PartyBean;
import org.ow2.dragon.ui.uibeans.organization.PersonBean;
import org.ow2.dragon.util.StringHelper;
import org.ow2.dragon.util.XMLUtil;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.w3c.dom.Document;

public class EndpointBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private EndpointTO endpoint;
    private List<PersonToEndpointTO> personRoles;
    private List<OrgToEndpointTO> organizationRoles;
    private List<BindingOperationTO> operations;
    private ProcessorTO hostProcessor;
    private ExecutionEnvironmentTO hostExecEnv;
    private TechnicalServiceTO service;
    private String bindingId;
    private String name;
    private String networkAddress;
    private List<KeyedRefTO> categories;
    private List<String> selectedCategories;
    private List<ServiceSpecificationTO> specsTO;
    private String user;
    private String fileDescriptionURL;
    private String fileDescriptionName;
    private boolean storeEntities;
    private Document wsdlDocContent;
    private String wsdlDocFileName;
    private int myRating;
    private float globalRating;
    private Set<String> tags = new HashSet();
    private List<CommentTO> comments;
    private String newComment;

    public void setMyRating(int rating) {
        this.myRating = rating;
    }

    public int getMyRating() {
        return this.myRating;
    }

    public void setGlobalRating(float globalRating) {
        this.globalRating = globalRating;
    }

    public void setGlobalRating(String globalRating) {
        this.globalRating = Float.parseFloat(globalRating);
    }

    public String getGlobalRating() {
        String toPrint = Float.toString(this.globalRating);
        return toPrint.substring(0, 3);
    }

    public void setTags(String tags) {
        String[] pieces = tags.split(",");
        for (int i = 0; i <= pieces.length - 1; ++i) {
            pieces[i] = pieces[i].trim();
            if (StringHelper.isNullOrEmpty((String)pieces[i])) continue;
            this.tags.add(pieces[i]);
        }
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags.toString();
    }

    public String getNewComment() {
        return this.newComment;
    }

    public void setNewComment(String newComment) {
        this.newComment = newComment;
    }

    public List<CommentTO> getComments() {
        return this.comments;
    }

    public void setComments(List<CommentTO> comments) {
        this.comments = comments;
    }

    public String addComment(String user) throws LocalizedError {
        String cmtTemp = this.newComment.trim();
        if (!StringHelper.isNullOrEmpty((String)cmtTemp)) {
            CommentTO newCommentTO = new CommentTO();
            newCommentTO.setContent(this.newComment);
            newCommentTO.setUserName(user);
            newCommentTO.setDate(new Date());
            try {
                DragonServiceFactory.getInstance().getEndpointManager().updateComments(this.endpoint.getId(), newCommentTO);
                EndpointTO endpointTemp = DragonServiceFactory.getInstance().getEndpointManager().getEndpoint(this.endpoint.getId(), null);
                this.comments = endpointTemp.getComments();
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        this.newComment = "";
        return "success";
    }

    public String removeComment(HttpServletRequest request) throws LocalizedError {
        String id = request.getParameter("comment");
        try {
            DragonServiceFactory.getInstance().getEndpointManager().removeComment(this.endpoint.getId(), id);
            EndpointTO endpointTemp = DragonServiceFactory.getInstance().getEndpointManager().getEndpoint(this.endpoint.getId(), null);
            this.comments = endpointTemp.getComments();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String create(HttpServletRequest request) throws IError {
        try {
            DragonServiceFactory.getInstance().getEndpointManager().createEndpoint(this.name, this.networkAddress, request.getParameter("servId"));
        }
        catch (DeploymentException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create endpoint.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String removeEndpoint(String endpointId) throws IError {
        try {
            DragonServiceFactory.getInstance().getEndpointManager().removeEndpoint(endpointId);
        }
        catch (DeploymentException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create endpoint.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String id = iRequest.getParameter("endpointId");
        this.user = iRequest.getUserPrincipal().getName();
        this.load(id);
    }

    private void load(String id) throws LocalizedError {
        try {
            this.endpoint = DragonServiceFactory.getInstance().getEndpointManager().getEndpoint(id, this.user);
            this.loadOrgRoles();
            this.loadPersonRoles();
            this.loadServiceSpecs();
            this.loadHostProcessor();
            this.loadHostExecEnv();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    private void loadHostProcessor() throws LocalizedError {
        if (this.endpoint.getHostProcessorId() != null) {
            try {
                this.hostProcessor = DragonServiceFactory.getInstance().getTechnologyManager().getProcessor(this.endpoint.getHostProcessorId());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
    }

    private void loadHostExecEnv() throws LocalizedError {
        if (this.endpoint.getHostExecEnvId() != null) {
            try {
                this.hostExecEnv = DragonServiceFactory.getInstance().getTechnologyManager().getExecutionEnvironment(this.endpoint.getHostExecEnvId());
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
    }

    public String loadServiceSpecs() throws LocalizedError {
        try {
            List result = DragonServiceFactory.getInstance().getWSDLImporter().getServSpecsForEndpoint(this.endpoint.getId());
            if (result != null) {
                for (ServiceSpecificationTO serviceSpecificationTO : result) {
                    if (serviceSpecificationTO.getFileName() != null) continue;
                    serviceSpecificationTO.setFileName("wsdlFile.wsdl");
                }
            }
            this.specsTO = result;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void loadWSDLDesc(HttpServletResponse response, String serviceSpecId) throws LocalizedError, IOException {
        InputStream input = null;
        try {
            input = DragonServiceFactory.getInstance().getWSDLImporter().getWsdlDesc(serviceSpecId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        ServletOutputStream output = response.getOutputStream();
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        byte[] buffer = new byte[512];
        int len = 0;
        while ((len = input.read(buffer)) >= 0) {
            output.write(buffer, 0, len);
        }
        output.flush();
        output.close();
    }

    public String save() throws LocalizedError {
        EndpointTO newEndpoint = new EndpointTO();
        newEndpoint.setId(this.endpoint.getId());
        newEndpoint.setName(this.name);
        newEndpoint.setNetworkAddress(this.networkAddress);
        newEndpoint.setTechService(this.service);
        newEndpoint.setProtocols(this.endpoint.getProtocols());
        newEndpoint.setTransports(this.endpoint.getTransports());
        RatingTO ratingTO = new RatingTO();
        ratingTO.setMyRating(this.myRating);
        ratingTO.setUserName(this.endpoint.getRatingTO().getUserName());
        ratingTO.setId(this.endpoint.getRatingTO().getid());
        newEndpoint.setRatingTO(ratingTO);
        newEndpoint.setTags(this.tags);
        newEndpoint.setComments(this.comments);
        try {
            DragonServiceFactory.getInstance().getEndpointManager().updateEndpoint(newEndpoint);
            this.globalRating = DragonServiceFactory.getInstance().getEndpointManager().updateGlobalRating(newEndpoint.getId());
            newEndpoint.setGlobalRating(this.globalRating);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.endpoint = newEndpoint;
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getEndpointManager().removeEndpoint(this.endpoint.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        this.name = this.endpoint.getName();
        this.networkAddress = this.endpoint.getNetworkAddress();
        this.service = this.endpoint.getTechService();
        if (this.endpoint.getBinding() != null) {
            this.bindingId = this.endpoint.getBinding().getId();
            this.operations = this.endpoint.getBinding().getBindingOps();
        }
        this.categories = this.endpoint.getCategories();
        this.myRating = this.endpoint.getRatingTO().getMyRating();
        this.globalRating = this.endpoint.getGlobalRating();
        this.comments = this.endpoint.getComments();
        this.tags = this.endpoint.getTags();
    }

    public void clear() {
        this.endpoint = new EndpointTO();
        this.user = null;
        this.reset();
    }

    public List<String> getEndpointProvidersString() throws OrganizationException, DragonDelegateException, LocalizedError {
        ArrayList<String> res = new ArrayList<String>();
        for (PartyBean p : this.getEndpointProviders()) {
            res.add(p.getGenericName());
        }
        if (res.size() == 0) {
            res.add("anonymous_provider");
        }
        return res;
    }

    public List<PartyBean> getEndpointProviders() throws OrganizationException, DragonDelegateException, LocalizedError {
        ArrayList<PartyBean> res = new ArrayList<PartyBean>();
        this.loadPersonRoles();
        this.loadOrgRoles();
        if (this.personRoles != null) {
            for (PersonToEndpointTO personRole : this.personRoles) {
                if (!personRole.getType().equals("Manager")) continue;
                res.add((PartyBean)new PersonBean(personRole.getPersonTO()));
            }
        }
        if (this.organizationRoles != null) {
            for (OrgToEndpointTO organizationRole : this.organizationRoles) {
                if (!organizationRole.getType().equals("Provider")) continue;
                res.add((PartyBean)new OrganizationBean(organizationRole.getOrganizationUnitTO()));
            }
        }
        return res;
    }

    public void loadCategories() throws LocalizedError {
        try {
            this.categories = DragonServiceFactory.getInstance().getEndpointManager().getCategoriesForEndpoint(this.endpoint.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String removeCategories() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getEndpointManager().removeCategories(this.endpoint.getId(), this.selectedCategories);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadCategories();
        return "success";
    }

    public String authorizeSLACreation(String type) {
        String res = null;
        if (type.equals("Consumer") || type.equals("User")) {
            res = "Create or Submit Agreement Offer";
        } else if (type.equals("Provider") || type.equals("Manager")) {
            res = "Create Agreement Template or Accept Offer";
        }
        return res;
    }

    public void loadPersonRoles() throws OrganizationException, DragonDelegateException {
        this.personRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getPersonRolesByEndpoint(this.endpoint.getId(), this.createSortOption(SortCriteria.LINK_TYPE, true));
    }

    public void loadOrgRoles() throws OrganizationException, DragonDelegateException {
        this.organizationRoles = DragonServiceFactory.getInstance().getRoleOfPartyManager().getOrgRolesByEndpoint(this.endpoint.getId(), this.createSortOption(SortCriteria.LINK_TYPE, true));
    }

    public String deleteRole(HttpServletRequest request) throws LocalizedError {
        String roleToDeleteId = request.getParameter("roleToDelete");
        try {
            DragonServiceFactory.getInstance().getRoleOfPartyManager().removeRole(roleToDeleteId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.load(request);
        return "success";
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String addServiceDesc() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getEndpointManager().addServiceDefFile(URI.create(this.fileDescriptionURL), this.fileDescriptionName, this.endpoint.getId(), this.storeEntities);
            if (this.storeEntities) {
                this.load(this.endpoint.getId());
            } else {
                this.loadServiceSpecs();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void clearAddWsdl() {
        this.fileDescriptionURL = null;
        this.fileDescriptionName = null;
        this.storeEntities = false;
        this.wsdlDocContent = null;
        this.wsdlDocFileName = null;
    }

    public void uploadServDesc(IFileUploadPart file) throws LocalizedError {
        try {
            this.wsdlDocContent = XMLUtil.loadDocument((InputStream)file.getFileInputStream());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.wsdlDocFileName = this.extractShortFilename(file);
    }

    private String extractShortFilename(IFileUploadPart file) {
        String fileName = file.getFileName();
        if (fileName != null) {
            if (fileName.contains("/")) {
                String[] parts = fileName.split("/");
                fileName = parts[parts.length - 1];
            } else if (fileName.contains("\\")) {
                String[] parts = fileName.split("\\u005C+");
                fileName = parts[parts.length - 1];
            }
        }
        return fileName;
    }

    public String addServiceDescFromFile() throws LocalizedError {
        String fileName = StringHelper.isNullOrEmpty((String)this.fileDescriptionName) ? this.wsdlDocFileName : this.fileDescriptionName;
        try {
            DragonServiceFactory.getInstance().getEndpointManager().addServiceDefFile(this.wsdlDocContent, fileName, this.endpoint.getId(), this.storeEntities);
            if (this.storeEntities) {
                this.load(this.endpoint.getId());
            } else {
                this.loadServiceSpecs();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String removeServSpec(String documentId) throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getEndpointManager().removeServiceSpec(this.endpoint.getId(), documentId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return this.loadServiceSpecs();
    }

    public String getId() {
        if (this.endpoint == null) {
            return "";
        }
        return this.endpoint.getId();
    }

    public EndpointTO getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(EndpointTO endpoint) {
        this.endpoint = endpoint;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public String getProtocol() {
        return this.endpoint.getProtocol();
    }

    public List<PersonToEndpointTO> getPersonRoles() {
        return this.personRoles;
    }

    public void setPersonRoles(List<PersonToEndpointTO> personRoles) {
        this.personRoles = personRoles;
    }

    public List<OrgToEndpointTO> getOrganizationRoles() {
        return this.organizationRoles;
    }

    public void setOrganizationRoles(List<OrgToEndpointTO> organizationRoles) {
        this.organizationRoles = organizationRoles;
    }

    public List<BindingOperationTO> getOperations() {
        return this.operations;
    }

    public void setOperations(List<BindingOperationTO> operations) {
        this.operations = operations;
    }

    public List<ServiceSpecificationTO> getSpecsTO() {
        return this.specsTO;
    }

    public void setSpecsTO(List<ServiceSpecificationTO> specsTO) {
        this.specsTO = specsTO;
    }

    public ProcessorTO getHostProcessor() {
        return this.hostProcessor;
    }

    public void setHostProcessor(ProcessorTO hostProcessor) {
        this.hostProcessor = hostProcessor;
    }

    public ExecutionEnvironmentTO getHostExecEnv() {
        return this.hostExecEnv;
    }

    public void setHostExecEnv(ExecutionEnvironmentTO hostExecEnv) {
        this.hostExecEnv = hostExecEnv;
    }

    public TechnicalServiceTO getService() {
        return this.service;
    }

    public void setService(TechnicalServiceTO service) {
        this.service = service;
    }

    public List<KeyedRefTO> getCategories() {
        return this.categories;
    }

    public void setCategories(List<KeyedRefTO> categories) {
        this.categories = categories;
    }

    public List<String> getSelectedCategories() {
        return this.selectedCategories;
    }

    public void setSelectedCategories(List<String> selectedCategories) {
        this.selectedCategories = selectedCategories;
    }

    public String getFileDescriptionURL() {
        return this.fileDescriptionURL;
    }

    public void setFileDescriptionURL(String fileDescriptionURL) {
        this.fileDescriptionURL = fileDescriptionURL;
    }

    public String getFileDescriptionName() {
        return this.fileDescriptionName;
    }

    public void setFileDescriptionName(String fileDescriptionName) {
        this.fileDescriptionName = fileDescriptionName;
    }

    public boolean isStoreEntities() {
        return this.storeEntities;
    }

    public void setStoreEntities(boolean storeEntities) {
        this.storeEntities = storeEntities;
    }
}

