/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.organization.PersonSearchProperties;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

public class ListOfPersonsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private String organizationId;
    List<PersonTO> persons;
    private String searchCriteria;
    private List<String> searchedProperties;

    public void loadAll() throws LocalizedError {
        try {
            this.persons = DragonServiceFactory.getInstance().getPersonManager().getAllPersons(this.createSortOption(SortCriteria.PERSON_LASTNAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadByOrganization(String orgId) throws LocalizedError {
        this.organizationId = orgId;
        try {
            this.persons = DragonServiceFactory.getInstance().getPersonManager().getPersonsByOrganization(this.organizationId, this.createSortOption(SortCriteria.PERSON_LASTNAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public List<PersonTO> getPersonsToLink() {
        ArrayList<PersonTO> personsToLink = new ArrayList();
        if (this.persons != null && !this.persons.isEmpty()) {
            personsToLink = this.persons;
        } else {
            PersonTO emptyPerson = new PersonTO();
            emptyPerson.setId("");
            emptyPerson.setLastname("No person to link");
            personsToLink.add(emptyPerson);
        }
        return personsToLink;
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            List properties = this.convertSearchedProperties(searchedProperties);
            try {
                this.persons = DragonServiceFactory.getInstance().getPersonManager().searchPersons(searchCriteria, properties, this.createSortOption(SortCriteria.PERSON_LASTNAME, true));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.persons == null || this.persons.size() == 0) {
                LocalizedError error = new LocalizedError("search_person_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    private List<PersonSearchProperties> convertSearchedProperties(List<String> searchedProperties2) {
        ArrayList<PersonSearchProperties> result = new ArrayList<PersonSearchProperties>();
        for (String prop : searchedProperties2) {
            PersonSearchProperties propEnum = PersonSearchProperties.fromString((String)prop);
            if (propEnum == null) continue;
            result.add(propEnum);
        }
        return result;
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public List<PersonTO> getPersons() {
        return this.persons;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }
}

