/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.organization.OrganizationBean;
import org.ow2.dragon.ui.uibeans.organization.PartyBean;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class PersonBean
extends PartyBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private PersonTO person;
    private String organizationId;
    private String postId;
    private String title;
    private String firstname;
    private String middlename;
    private String lastname;
    private String email;
    private String phone;
    private String localization;
    private boolean contact;

    public PersonBean() {
    }

    public PersonBean(PersonTO p) {
        this.person = p;
        this.reset();
    }

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String id = iRequest.getParameter("personId");
        try {
            this.person = DragonServiceFactory.getInstance().getPersonManager().getPerson(id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    public String loadNew(HttpServletRequest iRequest) throws LocalizedError {
        String id = iRequest.getParameter("organizationId");
        try {
            OrganizationUnitTO organization = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(id);
            this.person = new PersonTO();
            this.person.setOrganization(organization);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
        return "success";
    }

    public String save() throws IError {
        OrganizationUnitTO organization = null;
        try {
            organization = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(this.organizationId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        PostTO post = null;
        try {
            post = DragonServiceFactory.getInstance().getPostManager().getPost(this.postId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        PersonTO newPerson = new PersonTO();
        newPerson.setId(this.person.getId());
        newPerson.setOrganization(organization);
        newPerson.setEmail(this.email);
        newPerson.setTitle(this.title);
        newPerson.setFirstname(this.firstname);
        newPerson.setLastname(this.lastname);
        newPerson.setLocalization(this.localization);
        newPerson.setMiddlename(this.middlename);
        newPerson.setPhone(this.phone);
        newPerson.setPost(post);
        newPerson.setContact(this.contact);
        try {
            DragonServiceFactory.getInstance().getPersonManager().updatePerson(newPerson);
        }
        catch (OrganizationException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create person", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.person = newPerson;
        return "success";
    }

    public String create(HttpServletRequest request, OrganizationBean orgBean) throws IError {
        OrganizationUnitTO organization = null;
        try {
            organization = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(this.organizationId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        PostTO post = null;
        try {
            post = DragonServiceFactory.getInstance().getPostManager().getPost(this.postId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        PersonTO newPerson = new PersonTO();
        newPerson.setOrganization(organization);
        newPerson.setEmail(this.email);
        newPerson.setFirstname(this.firstname);
        newPerson.setLastname(this.lastname);
        newPerson.setLocalization(this.localization);
        newPerson.setMiddlename(this.middlename);
        newPerson.setPhone(this.phone);
        newPerson.setPost(post);
        newPerson.setTitle(this.title);
        newPerson.setContact(this.contact);
        String personId = "";
        try {
            personId = DragonServiceFactory.getInstance().getPersonManager().createPerson(newPerson);
        }
        catch (OrganizationException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create person", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        try {
            this.person = DragonServiceFactory.getInstance().getPersonManager().getPerson(personId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        orgBean.load(request);
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getPersonManager().removePerson(this.person.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        this.organizationId = this.person.getOrganization() != null ? this.person.getOrganization().getId() : "";
        this.postId = this.person.getPost() != null ? this.person.getPost().getId() : "";
        this.email = this.person.getEmail();
        this.title = this.person.getTitle();
        this.firstname = this.person.getFirstname();
        this.lastname = this.person.getLastname();
        this.localization = this.person.getLocalization();
        this.middlename = this.person.getMiddlename();
        this.phone = this.person.getPhone();
        this.contact = this.person.isContact();
    }

    public void clear() {
        this.person = new PersonTO();
        this.reset();
    }

    public void validate() throws ValidationErrors {
    }

    public String orgPostExistence() throws LocalizedError {
        List posts;
        List organizations;
        String result = "";
        try {
            organizations = DragonServiceFactory.getInstance().getOrganizationManager().getAllOrganizations(null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        try {
            posts = DragonServiceFactory.getInstance().getPostManager().getAllPosts(null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        result = organizations == null || organizations.isEmpty() || posts == null || posts.isEmpty() ? "zero" : "success";
        return result;
    }

    public String getId() {
        if (this.person == null) {
            return "";
        }
        return this.person.getId();
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getMiddlename() {
        return this.middlename;
    }

    public void setMiddlename(String middlename) {
        this.middlename = middlename;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getLocalization() {
        return this.localization;
    }

    public void setLocalization(String localization) {
        this.localization = localization;
    }

    public String getPostId() {
        return this.postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getGenericName() {
        return this.lastname + "_" + this.getFirstname();
    }

    public String toString() {
        return this.getGenericName();
    }

    public boolean isContact() {
        return this.contact;
    }

    public void setContact(boolean contact) {
        this.contact = contact;
    }
}

