/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.opensuit.core.error.LocalizedError;

public class AgreementClientBoardBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<ManagedAgreementBean> agreementOffersNotSubmit = new ArrayList();
    private List<ManagedAgreementBean> agreementOffersPending = new ArrayList();
    private List<ManagedAgreementBean> submittedAgreements = new ArrayList();
    private List<ManagedAgreementBean> observedAgreements = new ArrayList();
    private List<ManagedAgreementBean> terminatedAgreements = new ArrayList();

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        try {
            this.agreementOffersNotSubmit = new ArrayList();
            this.agreementOffersPending = new ArrayList();
            this.submittedAgreements = new ArrayList();
            this.observedAgreements = new ArrayList();
            this.terminatedAgreements = new ArrayList();
            String clientId = iRequest.getParameter("personId");
            if (clientId.equals("-1")) {
                clientId = iRequest.getParameter("organizationId");
            }
            for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager().getAllManagedAgreements(null)) {
                if (agTO.getIdClient() == null || !agTO.getIdClient().equals(clientId) || !(agTO.getAgreement() instanceof AgreementLifeCycle)) continue;
                if (((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.OFFER_RECEIVE)) {
                    this.agreementOffersNotSubmit.add(new ManagedAgreementBean(agTO));
                    continue;
                }
                if (((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.PENDING)) {
                    this.agreementOffersPending.add(new ManagedAgreementBean(agTO));
                    continue;
                }
                if (((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.OBSERVE)) {
                    this.observedAgreements.add(new ManagedAgreementBean(agTO));
                    continue;
                }
                if (((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.REJECTE)) {
                    this.terminatedAgreements.add(new ManagedAgreementBean(agTO));
                    continue;
                }
                if (!((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.TERMINATE)) continue;
                this.terminatedAgreements.add(new ManagedAgreementBean(agTO));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void reset() {
    }

    public List<ManagedAgreementBean> getAgreementOffersNotSubmit() {
        return this.agreementOffersNotSubmit;
    }

    public void setAgreementOffersNotSubmit(List<ManagedAgreementBean> agreementOffers) {
        this.agreementOffersNotSubmit = agreementOffers;
    }

    public List<ManagedAgreementBean> getAgreementOffersPending() {
        return this.agreementOffersPending;
    }

    public void setAgreementOffersPending(List<ManagedAgreementBean> agreementOffersPending) {
        this.agreementOffersPending = agreementOffersPending;
    }

    public List<ManagedAgreementBean> getSubmittedAgreements() {
        return this.submittedAgreements;
    }

    public void setSubmittedAgreements(List<ManagedAgreementBean> submittedAgreements) {
        this.submittedAgreements = submittedAgreements;
    }

    public List<ManagedAgreementBean> getObservedAgreements() {
        return this.observedAgreements;
    }

    public void setObservedAgreements(List<ManagedAgreementBean> observedAgreements) {
        this.observedAgreements = observedAgreements;
    }

    public List<ManagedAgreementBean> getTerminatedAgreements() {
        return this.terminatedAgreements;
    }

    public void setTerminatedAgreements(List<ManagedAgreementBean> terminatedAgreements) {
        this.terminatedAgreements = terminatedAgreements;
    }
}

