/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.AgreementTemplate;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.EndpointBean;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.opensuit.core.error.LocalizedError;

public class AgreementProviderBoardBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<ManagedAgreementBean> agreementTemplates = new ArrayList();
    private List<ManagedAgreementBean> submittedAgreements = new ArrayList();
    private List<ManagedAgreementBean> observedAgreements = new ArrayList();
    private List<ManagedAgreementBean> terminatedAgreements = new ArrayList();

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        try {
            this.agreementTemplates = new ArrayList();
            this.submittedAgreements = new ArrayList();
            this.observedAgreements = new ArrayList();
            this.terminatedAgreements = new ArrayList();
            EndpointBean ep = new EndpointBean();
            ep.load(iRequest);
            for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager().getAllManagedAgreements(null)) {
                if (agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()) && agTO.getAgreement() instanceof AgreementTemplate) {
                    this.agreementTemplates.add(new ManagedAgreementBean(agTO));
                }
                if (!agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()) || !(agTO.getAgreement() instanceof AgreementLifeCycle)) continue;
                if (((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.PENDING)) {
                    this.submittedAgreements.add(new ManagedAgreementBean(agTO));
                    continue;
                }
                if (((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.OBSERVE)) {
                    this.observedAgreements.add(new ManagedAgreementBean(agTO));
                    continue;
                }
                if (((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.REJECTE)) {
                    this.terminatedAgreements.add(new ManagedAgreementBean(agTO));
                    continue;
                }
                if (!((AgreementLifeCycle)agTO.getAgreement()).getState().equals((Object)AgreementLifeCycle.State.TERMINATE)) continue;
                this.terminatedAgreements.add(new ManagedAgreementBean(agTO));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public List<ManagedAgreementBean> getAllAgreementsTemplateOfEndpoint(EndpointBean ep) throws LocalizedError {
        ArrayList<ManagedAgreementBean> res = new ArrayList<ManagedAgreementBean>();
        try {
            for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager().getAllManagedAgreements(null)) {
                if (!agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()) || !(agTO.getAgreement() instanceof AgreementTemplate)) continue;
                res.add(new ManagedAgreementBean(agTO));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return res;
    }

    public ManagedAgreementBean getAgreementTemplateByName(EndpointBean ep, String name) throws LocalizedError {
        ManagedAgreementBean res = null;
        try {
            for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager().getAllManagedAgreements(null)) {
                if (!agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()) || !(agTO.getAgreement() instanceof AgreementTemplate) || !agTO.getAgreement().getName().equals(name)) continue;
                res = new ManagedAgreementBean(agTO);
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return res;
    }

    public void reset() {
    }

    public List<ManagedAgreementBean> getAgreementTemplates() {
        return this.agreementTemplates;
    }

    public void setAgreementTemplates(List<ManagedAgreementBean> agreementTemplates) {
        this.agreementTemplates = agreementTemplates;
    }

    public List<ManagedAgreementBean> getSubmittedAgreements() {
        return this.submittedAgreements;
    }

    public void setSubmittedAgreements(List<ManagedAgreementBean> submittedAgreements) {
        this.submittedAgreements = submittedAgreements;
    }

    public List<ManagedAgreementBean> getObservedAgreements() {
        return this.observedAgreements;
    }

    public void setObservedAgreements(List<ManagedAgreementBean> observedAgreements) {
        this.observedAgreements = observedAgreements;
    }

    public List<ManagedAgreementBean> getTerminatedAgreements() {
        return this.terminatedAgreements;
    }

    public void setTerminatedAgreements(List<ManagedAgreementBean> terminatedAgreements) {
        this.terminatedAgreements = terminatedAgreements;
    }
}

