/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.api.BusinessValueList;
import com.ebmwebsourcing.agreement.definition.api.Compensation;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.ui.uibeans.sla.CompensationBean;
import org.ow2.dragon.ui.uibeans.sla.GuaranteeBean;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.opensuit.core.error.LocalizedError;

public class BusinessValueBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private BusinessValueList bvTO;
    private ManagedAgreementBean mab;
    private GuaranteeBean gb;
    private int importance;
    private List<CompensationBean> penalties = new ArrayList();
    private List<CompensationBean> rewards = new ArrayList();

    private List<CompensationBean> initCompensationBean(List<Compensation> compsTO, String compensationType) throws LocalizedError {
        ArrayList<CompensationBean> res = new ArrayList<CompensationBean>();
        int i = 0;
        for (Compensation compTO : compsTO) {
            res.add(new CompensationBean(i, compTO, this, this.mab, compensationType));
            ++i;
        }
        return res;
    }

    public String save() throws LocalizedError {
        try {
            this.bvTO.setImportance(Integer.valueOf(this.importance));
            for (CompensationBean bean : this.penalties) {
                bean.save();
            }
            for (CompensationBean bean : this.rewards) {
                bean.save();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() throws LocalizedError {
        if (this.bvTO != null) {
            this.importance = this.bvTO.getImportance() != null ? this.bvTO.getImportance() : 0;
            if (this.bvTO != null) {
                this.penalties = this.initCompensationBean(this.bvTO.getPenalties(), "penalty");
                this.rewards = this.initCompensationBean(this.bvTO.getRewards(), "reward");
            }
        } else {
            this.importance = 0;
            this.penalties.clear();
            this.rewards.clear();
        }
    }

    public int getImportance() {
        return this.importance;
    }

    public void setImportance(int importance) {
        this.importance = importance;
    }

    public List<CompensationBean> getPenalties() {
        return this.penalties;
    }

    public void setPenalties(List<CompensationBean> penalties) {
        this.penalties = penalties;
    }

    public List<CompensationBean> getRewards() {
        return this.rewards;
    }

    public void setRewards(List<CompensationBean> rewards) {
        this.rewards = rewards;
    }

    public BusinessValueList getBvTO() {
        return this.bvTO;
    }

    public void setBvTO(BusinessValueList bvTO) {
        this.bvTO = bvTO;
    }

    public ManagedAgreementBean getMab() {
        return this.mab;
    }

    public void setMab(ManagedAgreementBean mab) {
        this.mab = mab;
    }

    public GuaranteeBean getGb() {
        return this.gb;
    }

    public void setGb(GuaranteeBean gb) {
        this.gb = gb;
    }
}

