/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

public class ListOfAgreementsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<ManagedAgreementBean> agreements = new ArrayList();
    private String fileDescriptionURL;
    private String searchCriteria;
    private boolean isSearchOnName;
    private boolean isSearchOnInitiator;
    private boolean isSearchOnResponder;
    private String selectedAgreementId;
    private String newLoadedAgreementId;
    private List<String> searchedProperties;

    public void loadAll() throws LocalizedError {
        try {
            for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager().getAllManagedAgreements(this.createSortOption(SortCriteria.AGREEMENT_NAME, true))) {
                this.agreements.add(new ManagedAgreementBean(agTO));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String loadNew() throws LocalizedError {
        try {
            this.newLoadedAgreementId = DragonServiceFactory.getInstance().getSLAManager().importAgreementDefFile(URI.create(this.fileDescriptionURL));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public List<ManagedAgreementBean> getAgreements() {
        return this.agreements;
    }

    public void setAgreements(List<ManagedAgreementBean> agreements) {
        this.agreements = agreements;
    }

    public String getFileDescriptionURL() {
        return this.fileDescriptionURL;
    }

    public void setFileDescriptionURL(String fileDescriptionURL) {
        this.fileDescriptionURL = fileDescriptionURL;
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            try {
                this.agreements = new ArrayList();
                for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager().searchManagedAgreement(searchCriteria, searchedProperties, this.createSortOption(SortCriteria.AGREEMENT_NAME, true))) {
                    this.agreements.add(new ManagedAgreementBean(agTO));
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.agreements == null || this.agreements.size() == 0) {
                LocalizedError error = new LocalizedError("search_agreement_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    public boolean getIsSearchOnInitiator() {
        return this.isSearchOnInitiator;
    }

    public void setIsSearchOnInitiator(boolean isSearchOnInitiator) {
        this.isSearchOnInitiator = isSearchOnInitiator;
    }

    public boolean getIsSearchOnName() {
        return this.isSearchOnName;
    }

    public void setIsSearchOnName(boolean isSearchOnName) {
        this.isSearchOnName = isSearchOnName;
    }

    public boolean getIsSearchOnResponder() {
        return this.isSearchOnResponder;
    }

    public void setIsSearchOnResponder(boolean isSearchOnResponder) {
        this.isSearchOnResponder = isSearchOnResponder;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public String getIsEditable(HttpServletRequest iRequest) {
        String editable = iRequest.getParameter("editable");
        return editable;
    }

    public String getSelectedAgreementId() {
        return this.selectedAgreementId;
    }

    public void setSelectedAgreementId(HttpServletRequest iRequest) {
        this.selectedAgreementId = iRequest.getParameter("agreementId");
    }

    public void setSelectedAgreementId(String selectedAgreementId) {
        this.selectedAgreementId = selectedAgreementId;
    }

    public String setAgreementProcess(HttpServletRequest iRequest) {
        this.setSelectedAgreementId(iRequest);
        return this.getIsEditable(iRequest);
    }

    public String getNewLoadedAgreementId() {
        return this.newLoadedAgreementId;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }
}

