/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.api.ServiceDescription;
import java.net.URI;
import org.apache.log4j.Logger;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.opensuit.core.error.LocalizedError;

public class ServiceDescriptionTermBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private ServiceDescription sdtTO;
    private ManagedAgreementBean mab;
    private String name = null;
    private String providerName = null;
    private String serviceName = null;
    private String wsdlURL = null;

    public ServiceDescriptionTermBean() {
    }

    public ServiceDescriptionTermBean(ServiceDescription sdtTO, ManagedAgreementBean mab) {
        this.sdtTO = sdtTO;
        this.mab = mab;
        this.reset();
    }

    public String save() throws LocalizedError {
        try {
            this.sdtTO.setName(this.name);
            this.sdtTO.setServiceName(this.serviceName);
            if (this.wsdlURL != null) {
                this.sdtTO.setWsdlDescription(new URI(this.wsdlURL));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        if (this.sdtTO != null) {
            this.name = this.sdtTO.getName();
            this.serviceName = this.sdtTO.getServiceName();
            if (this.sdtTO.getWsdlDescription() != null) {
                this.wsdlURL = this.sdtTO.getWsdlDescription().toString();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public ServiceDescription getSdtTO() {
        return this.sdtTO;
    }

    public void setSdtTO(ServiceDescription sdtTO) {
        this.sdtTO = sdtTO;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public ManagedAgreementBean getMab() {
        return this.mab;
    }

    public void setMab(ManagedAgreementBean mab) {
        this.mab = mab;
    }
}

