/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

public class EnvironmentFederationBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private EnvironmentFederationTO environmentFederationTO;
    private String environmentFederationId;
    private String name;
    private String pattern;
    private List<ExecutionEnvironmentTO> execEnvs;

    public String load(HttpServletRequest request) throws LocalizedError {
        String id = request.getParameter("envFedId");
        this.loadEnvironmentFederation(id);
        this.loadExecEnvs(id);
        this.reset();
        return "success";
    }

    public void loadEnvironmentFederation(String id) throws LocalizedError {
        try {
            this.environmentFederationTO = DragonServiceFactory.getInstance().getTechnologyManager().getEnvironmentFederation(id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadExecEnvs(String id) throws LocalizedError {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        try {
            this.execEnvs = DragonServiceFactory.getInstance().getTechnologyManager().getExecEnvsInFederation(id, requestOptionsTO);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void reset() {
        if (this.environmentFederationTO != null) {
            this.pattern = this.environmentFederationTO.getPattern();
            this.name = this.environmentFederationTO.getName();
            this.environmentFederationId = this.environmentFederationTO.getEnvFedId();
        }
    }

    public void save() {
    }

    public void validate() {
    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeEnvironmentFederation(this.environmentFederationTO.getEnvFedId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ExecutionEnvironmentTO> getExecEnvs() {
        return this.execEnvs;
    }

    public void setExecEnvs(List<ExecutionEnvironmentTO> execEnvs) {
        this.execEnvs = execEnvs;
    }

    public EnvironmentFederationTO getEnvironmentFederationTO() {
        return this.environmentFederationTO;
    }

    public void setEnvironmentFederationTO(EnvironmentFederationTO environmentFederationTO) {
        this.environmentFederationTO = environmentFederationTO;
    }

    public String getEnvironmentFederationId() {
        return this.environmentFederationId;
    }

    public void setEnvironmentFederationId(String environmentFederationId) {
        this.environmentFederationId = environmentFederationId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

