/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.utils;

import java.util.ArrayList;

public class ExactStringTokenizer {
    private static String[] STRING_ARRAY = new String[0];
    private String _str;
    private int _curTokenPos;
    private int _nextDelimPos;
    private char _delim;

    public static String[] split(String iString, char delim) {
        ArrayList<String> ret = new ArrayList<String>();
        ExactStringTokenizer st = new ExactStringTokenizer(iString, delim);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(STRING_ARRAY);
    }

    public ExactStringTokenizer(String iString, char delim) {
        this._str = iString;
        this._delim = delim;
        this.reinit();
    }

    private void reinit() {
        this._curTokenPos = 0;
        this._nextDelimPos = Integer.MIN_VALUE;
    }

    public boolean hasMoreTokens() {
        if (this._nextDelimPos == Integer.MIN_VALUE) {
            this._nextDelimPos = this._str.indexOf(this._delim, this._curTokenPos);
        }
        return this._nextDelimPos >= 0 || this._curTokenPos <= this._str.length();
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            return null;
        }
        String ret = null;
        if (this._nextDelimPos >= 0) {
            ret = this._str.substring(this._curTokenPos, this._nextDelimPos);
            this._curTokenPos = this._nextDelimPos + 1;
            this._nextDelimPos = Integer.MIN_VALUE;
        } else {
            ret = this._str.substring(this._curTokenPos);
            this._curTokenPos = this._str.length() + 1;
        }
        return ret;
    }
}

