/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * JAXBUtil.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

/**
 * @author nsaladge, ofabre - eBM Websourcing
 * 
 */
public class JAXBUtil {

    @SuppressWarnings("unchecked")
    public static JAXBContext createJAXBContext(List<Class> defaultObjectFactories)
            throws JAXBException {
        return createJAXBContext(defaultObjectFactories.toArray(new Class[defaultObjectFactories
                .size()]));
    }

    @SuppressWarnings("unchecked")
    public static JAXBContext createJAXBContext(Class... defaultObjectFactories)
            throws JAXBException {
        return JAXBContext.newInstance(defaultObjectFactories);
    }

    public static JAXBContext createJAXBContextFromPackages(String... packages)
            throws JAXBException {
        String allPackages = "";
        for (String pack : packages) {
            allPackages += pack;
        }
        return JAXBContext.newInstance(allPackages);
    }

    public static JAXBContext createJAXBContextFromPackages(String packages) throws JAXBException {
        return JAXBContext.newInstance(packages);
    }

    public static JAXBContext createJAXBContextFromPackages(List<String> packages)
            throws JAXBException {
        return createJAXBContextFromPackages(packages.toArray(new String[packages.size()]));
    }

    public static SchemaFactory createSchemaFactory(String xsdLocation) throws JAXBException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        try {
            factory.newSchema(new StreamSource[] { new StreamSource(InputStreamUtil
                    .getInputStream(xsdLocation)) });
        } catch (Exception e) {
            throw new JAXBException("Can't create JAXB Factory from xsd '" + xsdLocation, e);
        }
        return factory;
    }

}
