/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TModelType.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

import java.util.HashMap;
import java.util.Map;

/**
 * An enumeration of supported tmodel types
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public enum TModelType {
    CATEGORY("categorization"), PROTOCOL("protocol"), TRANSPORT("transport"), IDENTIFIER(
    "identifier");
	private final String type;

	private static final Map<String, TModelType> stringToEnum = new HashMap<String, TModelType>();

	static {
		for (TModelType type : values()) {
			stringToEnum.put(type.toString(), type);
		}
	}

	private TModelType(String type) {
		this.type = type;
	}

	@Override
	public String toString() {
		return this.type;
	}

	/**
	 * Return the TModelType related to the given string or null if it isn't
	 * supported
	 * 
	 * @param type
	 *            the string representing a potential TModelType
	 * @return the {@link TModelType} enum related to the given String
	 */
	public static TModelType fromString(String type) {
		return stringToEnum.get(type);
	}

}
