/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.springframework.util.ResourceUtils;

public class InputStreamUtil {
    private static final String FILE_SCHEME = "file";
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static InputStream getInputStream(String resourceLocation) throws IOException, URISyntaxException {
        return InputStreamUtil.getInputStream(ResourceUtils.getURL((String)resourceLocation));
    }

    public static InputStream getInputStream(URI resourceLocation) throws IOException, URISyntaxException {
        return InputStreamUtil.getInputStream(ResourceUtils.getURL((String)resourceLocation.toString()));
    }

    public static InputStream getInputStream(URL resourceLocation) throws IOException, URISyntaxException {
        InputStream result = null;
        if (FILE_SCHEME.equals(resourceLocation.getProtocol())) {
            File f = new File(resourceLocation.toURI());
            result = new FileInputStream(f);
        } else {
            result = ResourceUtils.getURL((String)resourceLocation.toString()).openStream();
        }
        return result;
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        InputStreamUtil.copy(input, output, 2048);
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int bytesRead = input.read(buf);
        while (bytesRead != -1) {
            output.write(buf, 0, bytesRead);
            bytesRead = input.read(buf);
        }
        output.flush();
    }

    public static void copyThenClose(InputStream input, OutputStream output) throws IOException {
        InputStreamUtil.copy(input, output);
        input.close();
        output.close();
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        InputStreamUtil.copy(input, result);
        result.close();
        return result.toByteArray();
    }
}

