/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.util;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class XMLPrettyPrinter {
    public static void prettify(Node node, OutputStream out) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        TransformerFactory tf = TransformerFactory.newInstance();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.transform(source, new StreamResult(out));
    }

    public static void prettify(InputStream in, OutputStream out) throws Exception {
        StreamSource source = new StreamSource(in);
        Source stylesheetSource = XMLPrettyPrinter.getStyleSheetSource();
        TransformerFactory tf = TransformerFactory.newInstance();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.transform(source, new StreamResult(out));
    }

    private static Source getStyleSheetSource() {
        StreamSource stylesheetSource = new StreamSource(XMLPrettyPrinter.class.getResourceAsStream("/prettyPrint.xsl"));
        return stylesheetSource;
    }
}

