/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SearchHelper.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

/**
 * @author ambarthe, ofabre - eBM WebSourcing
 * 
 */
public class SearchHelper {

    // private static final String regBody = "m/^\\s*$/";

    private static final String regPunct = "\\p{IsPunct}+"; // escape

    // punctuation

    private static final String regSymbol1 = "\\u00a4+"; // escape ""

    private static final String regSymbol2 = "\\u00a7+"; // escape ""

    private static final String regSymbol3 = "\\u00a8+"; // escape "  "

    private static final String regSymbol4 = "\\u00b0+"; // escape ""

    private static final String regSymbol5 = "\\u002b+"; // escape "+"

    private static final String regSymbol6 = "\\u003c+"; // escape "<"

    private static final String regSymbol7 = "\\u003d+"; // escape "="

    private static final String regSymbol8 = "\\u003e+"; // escape ">"

    private static final String regSymbol9 = "\\u005e+"; // escape "^"

    private static final String regSymbol10 = "\\u0060+"; // escape "`"

    private static final String regSymbol11 = "\\u007c+"; // escape "|"

    private static final String regSymbol12 = "\\u007e+"; // escape "~"

    private static final String regSymbol13 = "\\u20AC+"; // escape ""

    private static final String regSymbol14 = "\\s+"; // escape multiple spaces

    private static final String regSymbol15 = "^\\s"; // escape spaces at the beginning...

    private static final String regSymbol16 = "\\s+$//"; // ...and in the end
    
    private static final String regSymbol17 = "\\u007B+"; // "{"
    
    private static final String regSymbol18 = "\\u007D+"; // "}"
    
    private static final String regSymbol19 = "\\u003A+"; // "}"

    // !

    private static final String space = " ";
    private static final String noSpace = "";

    // private static final String noSpace = "";

    public static String[] splitSearchCriteria(String searchCriteria) {
        String[] keyword_list = null;
        if (!StringHelper.isNullOrEmpty(searchCriteria)) {
            // Escape all "exotic" characters from the search criteria
            //searchCriteria = searchCriteria.replaceAll(regPunct, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol17, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol18, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol19, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol1, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol2, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol3, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol4, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol5, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol6, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol7, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol8, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol9, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol10, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol11, space);
            //searchCriteria = searchCriteria.replaceAll(regSymbol12, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol13, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol14, space);
            searchCriteria = searchCriteria.replaceAll(regSymbol15, noSpace);
            searchCriteria = searchCriteria.replaceAll(regSymbol16, noSpace);
            


            // ... and parse $search_criteria into an array of keywords based on
            // word boundary (\s+ splits on whitespace)
            keyword_list = searchCriteria.split("\\s");
        }
        return keyword_list;
    }

}
