/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * DragonRepoFileLocator.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.util;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Olivier - ebmwebsourcing
 * 
 */
public class DragonRepoFileLocator {

    /**
     * Build a repository file url from "dragon.properties" and given
     * parameters. The URL pattern is : <br/>
     * {scheme}://{host}:{port}{contextName}
     * /repository/{fileName}{suffix}?fileId={fileId}
     * 
     * @param type
     *            the content type of the file, used to choose a file "suffix"
     * @param fileName
     *            the file name
     * @param fileId
     *            the file unique identifier
     * @param context
     *            the servlet context
     * @return a repository file url
     * @throws IOException
     *             if the dragon.properties file can't be read
     */
    public static String getRepoFileURL(ContentType type, String fileName, String fileId,
            HttpServletRequest request) throws IOException {
        String url = "";

        String contextPath = request.getContextPath();
        String scheme = request.getScheme();
        String host = request.getServerName();
        String port = String.valueOf(request.getServerPort());

        // Build url
        url = scheme + "://" + host + ":" + port + contextPath + "/repository/"
                + (fileName != null ? fileName : "file" + ContentType.getRelatedSuffix(type))
                + "?fileId=" + fileId;

        return url;
    }
}
